/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.util.logging.Level;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TileTrackTESR;
import mods.railcraft.common.blocks.tracks.TrackBufferStop;
import mods.railcraft.common.util.misc.Game;

public class TrackFactory {
    public static TileTrack makeTrackTile(int trackID) {
        TrackSpec spec = TrackRegistry.getTrackSpec(trackID);
        if (spec == null) {
            Game.log(Level.SEVERE, "Attempted to create Track Tile with invalid Track ID {0}", trackID);
            return null;
        }
        return TrackFactory.makeTrackTile(spec.createInstanceFromSpec());
    }

    public static TileTrack makeTrackTile(ITrackInstance track) {
        if (track instanceof TrackBufferStop) {
            return new TileTrackTESR(track);
        }
        return new TileTrack(track);
    }
}

