/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackLockingBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class TrackBoarding
extends TrackLockingBase
implements ITrackPowered,
ITrackReversable,
ITrackLockdown {
    protected boolean reversed = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.BOARDING;
    }

    @Override
    public Icon getIcon() {
        if (this.isPowered() || this.delay > 0) {
            if (this.isReversed()) {
                return this.getIcon(2);
            }
            return this.getIcon(0);
        }
        if (this.isReversed()) {
            return this.getIcon(3);
        }
        return this.getIcon(1);
    }

    @Override
    public void updateEntity() {
        if (this.getCurrentCart() != null && this.getCurrentCart().field_70128_L) {
            this.setCurrentCart(null);
        }
        if (Game.isHost(this.getWorld())) {
            if (this.isPowered()) {
                this.delay = this.getDelayTime();
            } else if (this.delay > 0) {
                this.delay = (byte)(this.delay - 1);
                if (this.delay == 0) {
                    this.setCurrentCart(null);
                }
            }
        }
        if (this.prevDelay == 0 ^ this.delay == 0) {
            this.sendUpdateToClient();
        }
        this.prevDelay = this.delay;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        this.checkCart(cart);
        int meta = this.tileEntity.func_70322_n();
        if (this.isPowered() || this.delay > 0) {
            this.releaseCart(cart);
            double speed = CartTools.getCartSpeedUncapped(cart);
            double boostX = START_BOOST;
            double boostZ = START_BOOST;
            if (speed > 0.005) {
                boostX = Math.abs(cart.field_70159_w) / speed * BOOST_FACTOR;
                boostZ = Math.abs(cart.field_70179_y) / speed * BOOST_FACTOR;
            }
            if (meta == 0 || meta == 4 || meta == 5) {
                cart.field_70179_y = this.isReversed() ? (cart.field_70179_y += boostZ) : (cart.field_70179_y -= boostZ);
            } else if (meta == 1 || meta == 2 || meta == 3) {
                cart.field_70159_w = this.isReversed() ? (cart.field_70159_w -= boostX) : (cart.field_70159_w += boostX);
            }
        } else {
            if (this.getCurrentCart() == null) {
                this.setCurrentCart(cart);
            }
            if (this.getCurrentCart() == cart) {
                this.lockCart(cart);
                cart.field_70159_w = 0.0;
                cart.field_70179_y = 0.0;
                if (meta == 0 || meta == 4 || meta == 5) {
                    cart.field_70161_v = (double)this.tileEntity.field_70327_n + 0.5;
                } else {
                    cart.field_70165_t = (double)this.tileEntity.field_70329_l + 0.5;
                }
            }
        }
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("direction", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.reversed = data.func_74767_n("direction");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

