/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.ore;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.client.particles.ParticleHelperCallback;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.blocks.ore.ItemOre;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemDust;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class BlockOre
extends Block {
    public static int renderPass;
    private final int renderType;
    private final Random rand = new Random();
    private static BlockOre instance;
    private static ParticleHelperCallback callback;

    public static BlockOre getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.ore")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            instance = new BlockOre(id, renderId);
            GameRegistry.registerBlock((Block)instance, ItemOre.class, (String)instance.func_71917_a());
            EntityTunnelBore.addMineableBlock(id);
            for (EnumOre ore : EnumOre.values()) {
                RailcraftLanguage.instance().registerItemName(ore.getItem(), ore.getTag());
                ForestryPlugin.addBackpackItem("miner", ore.getItem());
            }
            OreDictionary.registerOre((String)"oreSulfur", (ItemStack)EnumOre.SULFUR.getItem());
            OreDictionary.registerOre((String)"oreSaltpeter", (ItemStack)EnumOre.SALTPETER.getItem());
            OreDictionary.registerOre((String)"oreDiamond", (ItemStack)EnumOre.DARK_DIAMOND.getItem());
            OreDictionary.registerOre((String)"oreEmerald", (ItemStack)EnumOre.DARK_EMERALD.getItem());
            OreDictionary.registerOre((String)"oreLapis", (ItemStack)EnumOre.DARK_LAPIS.getItem());
        }
    }

    public BlockOre(int id, int renderId) {
        super(id, Material.field_76246_e);
        this.renderType = renderId;
        this.func_71864_b("railcraft.ore");
        this.func_71894_b(5.0f);
        this.func_71848_c(3.0f);
        this.func_71884_a(Block.field_71976_h);
        this.func_71849_a(CreativePlugin.TAB);
        MinecraftForge.setBlockHarvestLevel((Block)this, (String)"pickaxe", (int)2);
    }

    public int func_71857_b() {
        return this.renderType;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumOre ore : EnumOre.values()) {
            list.add(ore.getItem());
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return EnumOre.fromMeta(meta).getItem();
    }

    public void func_71914_a(World world, int x, int y, int z, int par5, float par6, int par7) {
        super.func_71914_a(world, x, y, z, par5, par6, par7);
        int xp = MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5);
        this.func_71923_g(world, x, y, z, xp);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        switch (EnumOre.fromMeta(meta)) {
            case SULFUR: {
                int qty = 2 + this.rand.nextInt(4) + this.rand.nextInt(fortune + 1);
                drops.add(ItemDust.getDust(ItemDust.EnumDust.SULFUR, qty));
                return drops;
            }
            case SALTPETER: {
                int qty = 1 + this.rand.nextInt(2) + this.rand.nextInt(fortune + 1);
                drops.add(ItemDust.getDust(ItemDust.EnumDust.SALTPETER, qty));
                return drops;
            }
            case DARK_DIAMOND: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = 1 * (bonus + 1);
                drops.add(new ItemStack(Item.field_77702_n, qty));
                return drops;
            }
            case DARK_EMERALD: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = 1 * (bonus + 1);
                drops.add(new ItemStack(Item.field_77817_bH, qty));
                return drops;
            }
            case DARK_LAPIS: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = (4 + this.rand.nextInt(5)) * (bonus + 1);
                drops.add(new ItemStack(Item.field_77756_aW, qty, 4));
                return drops;
            }
        }
        return super.getBlockDropped(world, x, y, z, meta, fortune);
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public void func_94332_a(IconRegister iconRegister) {
        for (EnumOre ore : EnumOre.VALUES) {
            ore.setTexture(iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(ore.getTag())));
        }
    }

    public Icon func_71858_a(int side, int meta) {
        if (renderPass == 0) {
            switch (EnumOre.fromMeta(meta)) {
                case SALTPETER: {
                    return Block.field_71957_Q.func_71858_a(ForgeDirection.DOWN.ordinal(), 0);
                }
                case DARK_DIAMOND: 
                case DARK_EMERALD: 
                case DARK_LAPIS: {
                    Icon icon = EnumCube.ABYSSAL_STONE.getIcon();
                    if (icon == null) break;
                    return icon;
                }
            }
            return Block.field_71981_t.func_71858_a(side, 0);
        }
        return EnumOre.fromMeta(meta).getTexture(side);
    }

    public void func_71919_f() {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockHitEffects(worldObj, instance, target, effectRenderer, callback);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockDestroyEffects(worldObj, instance, x, y, z, meta, effectRenderer, callback);
    }

    static {
        callback = new ParticleCallback();
    }

    private static class ParticleCallback
    implements ParticleHelperCallback {
        private ParticleCallback() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addBlockHitEffects(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            this.setTexture(fx, world, x, y, z, meta);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addBlockDestroyEffects(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            this.setTexture(fx, world, x, y, z, meta);
        }

        @SideOnly(value=Side.CLIENT)
        private void setTexture(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            renderPass = 0;
            fx.func_94052_a(Minecraft.func_71410_x().field_71446_o, instance.func_71858_a(0, meta));
        }
    }
}

