/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public abstract class TileLoaderLiquidBase
extends TileLoaderBase
implements IInventory,
ITankContainer,
ISidedInventory {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    protected static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    protected final TankManager tankManager = new TankManager();
    protected int flow = 0;

    protected TileLoaderLiquidBase() {
        this.setInventorySize(2);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasWork() {
        return this.flow > 0 && super.hasWork();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isHost(this.getWorld()) && this.clock % 128 == 0) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 1;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.tankManager.fill(tankIndex, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(tankIndex, maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection dir) {
        return this.tankManager.getTanks();
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tankManager.getTank(0);
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74781_a("tanks") instanceof NBTTagCompound) {
            data.func_74782_a("tanks", (NBTBase)new NBTTagList());
        }
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
    }
}

