/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderEnergyBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public class TileEnergyUnloader
extends TileLoaderEnergyBase
implements IEnergySource,
IGuiReturnHandler {
    private static final int[] OUTPUT_LEVELS = new int[]{512, 2048};
    private boolean waitTillEmpty = true;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ENERGY_UNLOADER;
    }

    @Override
    public Icon getIcon(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.UNLOADER_ENERGY, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void func_70316_g() {
        int emit;
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        int n = emit = this.transformerUpgrades > 0 ? OUTPUT_LEVELS[1] : OUTPUT_LEVELS[0];
        if (this.energy > emit) {
            int extra = IC2Plugin.emitEnergy(this, emit);
            this.energy -= emit - extra;
        }
        this.transferedEnergy = false;
        this.transferRate = 0;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.1f, this.direction);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        if (!(cart instanceof IEnergyTransfer)) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.isSendCartGateAction()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        if (!energyCart.canExtractEnergy() || energyCart.getTier() > this.getTier()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.actions.contains(Actions.PAUSE)) {
            return;
        }
        if (this.energy < this.getCapacity() && energyCart.getEnergy() > 0) {
            int extract;
            int usage = (int)((double)energyCart.getTransferLimit() * Math.pow(1.5, this.overclockerUpgrades));
            int injection = (int)((double)energyCart.getTransferLimit() * Math.pow(1.3, this.overclockerUpgrades));
            int room = this.getCapacity() - this.getEnergy();
            if (room < injection) {
                double ratio = (double)room / (double)injection;
                injection = room;
                usage = (int)((double)usage * ratio);
            }
            if ((extract = energyCart.extractEnergy(this, usage, this.getTier(), true, false, false)) < usage) {
                double ratio = (double)extract / (double)usage;
                usage = extract;
                injection = (int)((double)injection * ratio);
            }
            this.transferRate = injection;
            this.energy += injection;
            boolean bl = this.transferedEnergy = extract > 0;
        }
        if (!this.transferedEnergy && !this.isPowered() && CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            if (!this.waitTillEmpty) {
                this.setPowered(true);
            } else if (energyCart.getEnergy() == 0) {
                this.setPowered(true);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("WaitTillEmpty", this.waitTillEmpty());
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.setWaitTillEmpty(nbttagcompound.func_74767_n("WaitTillEmpty"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.waitTillEmpty = data.readBoolean();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.waitTillEmpty = data.readBoolean();
    }

    public boolean waitTillEmpty() {
        return this.waitTillEmpty;
    }

    public void setWaitTillEmpty(boolean wait) {
        this.waitTillEmpty = wait;
    }

    @Override
    public int getMaxEnergyOutput() {
        return OUTPUT_LEVELS[1];
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return this.direction != direction.toForgeDirection();
    }
}

