/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderEnergyBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public class TileEnergyLoader
extends TileLoaderEnergyBase
implements IEnergySink,
IGuiReturnHandler {
    private static final short[] INPUT_LEVELS = new short[]{512, 2048};
    private boolean waitTillFull = false;
    private boolean waitIfEmpty = true;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ENERGY_LOADER;
    }

    @Override
    public Icon getIcon(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_ENERGY, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.transferedEnergy = false;
        this.transferRate = 0;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.1f, this.direction);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        if (!(cart instanceof IEnergyTransfer)) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.isSendCartGateAction()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        if (!energyCart.canInjectEnergy() || energyCart.getTier() > this.getTier()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.actions.contains(Actions.PAUSE)) {
            return;
        }
        if (this.energy > 0 && energyCart.getEnergy() < energyCart.getCapacity()) {
            int usage = (int)((double)energyCart.getTransferLimit() * Math.pow(1.5, this.overclockerUpgrades));
            int injection = (int)((double)energyCart.getTransferLimit() * Math.pow(1.3, this.overclockerUpgrades));
            if (usage > this.energy) {
                double ratio = (double)this.energy / (double)usage;
                usage = this.energy;
                injection = (int)((double)injection * ratio);
            }
            this.transferRate = injection;
            int extra = energyCart.injectEnergy(this, injection, this.getTier(), true, false, false);
            this.energy -= usage - extra;
            boolean bl = this.transferedEnergy = extra != injection;
        }
        if (!this.transferedEnergy && !this.isPowered() && CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            if (!this.waitTillFull && energyCart.getEnergy() > 0) {
                this.setPowered(true);
            } else if (!this.waitIfEmpty && !this.waitTillFull && energyCart.getEnergy() == 0) {
                this.setPowered(true);
            } else if (energyCart.getEnergy() >= energyCart.getCapacity()) {
                this.setPowered(true);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("WaitIfEmpty", this.waitIfEmpty());
        nbttagcompound.func_74757_a("WaitTillFull", this.waitTillFull());
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.setWaitIfEmpty(nbttagcompound.func_74767_n("WaitIfEmpty"));
        this.setWaitTillFull(nbttagcompound.func_74767_n("WaitTillFull"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        byte bits = 0;
        bits = (byte)(bits | (this.waitIfEmpty ? 1 : 0));
        bits = (byte)(bits | (this.waitTillFull ? 2 : 0));
        data.writeByte(bits);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte bits = data.readByte();
        this.waitIfEmpty = (bits & 1) != 0;
        this.waitTillFull = (bits & 2) != 0;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitIfEmpty);
        data.writeBoolean(this.waitTillFull);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.waitIfEmpty = data.readBoolean();
        this.waitTillFull = data.readBoolean();
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > INPUT_LEVELS[0] && this.transformerUpgrades <= 0) {
            this.field_70331_k.func_72876_a(null, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, 2.0f, true);
            return 0;
        }
        this.energy += amount;
        int capacity = this.getCapacity();
        if (this.energy > capacity) {
            int extra = this.energy - capacity;
            this.energy = capacity;
            return extra;
        }
        return 0;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return this.direction != direction.toForgeDirection();
    }

    public boolean waitTillFull() {
        return this.waitTillFull;
    }

    public void setWaitTillFull(boolean waitTillFull) {
        this.waitTillFull = waitTillFull;
    }

    public boolean waitIfEmpty() {
        return this.waitIfEmpty;
    }

    public void setWaitIfEmpty(boolean waitIfEmpty) {
        this.waitIfEmpty = waitIfEmpty;
    }

    @Override
    public int demandsEnergy() {
        return this.getCapacity() - this.energy;
    }

    @Override
    public int getMaxSafeInput() {
        return this.transformerUpgrades <= 0 ? INPUT_LEVELS[0] : INPUT_LEVELS[1];
    }
}

