/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileTankIron;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.TankWrapper;
import mods.railcraft.common.liquids.tanks.FakeTank;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileTankIronValve
extends TileTankIron
implements ITankContainer {
    private static final byte FILL_INCREMENT = 1;
    private StandardTank fillTank = new StandardTank(20);

    public TileTankIronValve() {
        this.tankManager.addTank(this.fillTank);
    }

    private void setFilling(LiquidStack resource) {
        boolean needsUpdate = this.fillTank.isEmpty();
        resource = resource.copy();
        resource.amount = 20;
        this.fillTank.fill(resource, true);
        if (needsUpdate) {
            this.sendUpdateToClient();
        }
    }

    private void decrementFilling() {
        if (!this.fillTank.isEmpty()) {
            this.fillTank.drain(1, true);
            if (this.fillTank.isEmpty()) {
                this.sendUpdateToClient();
            }
        }
    }

    public boolean isFilling() {
        return !this.fillTank.isEmpty();
    }

    public StandardTank getFillTank() {
        return this.fillTank;
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.TANK_IRON_VALVE;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        this.decrementFilling();
        if (this.isMaster) {
            LiquidStack available;
            TileEntity tileBelow = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            TileTankIronValve tankBelow = null;
            if (tileBelow instanceof TileTankIronValve) {
                tankBelow = (TileTankIronValve)tileBelow;
                if (tankBelow.isStructureValid() && tankBelow.getPatternMarker() == 'T') {
                    StandardTank tank = tankBelow.getTankManager().getTank(0);
                    LiquidStack liquid = tank.getLiquid();
                    if (liquid != null && liquid.amount >= tank.getCapacity() - 1000) {
                        int used;
                        tankBelow = null;
                        LiquidStack fillStack = liquid.copy();
                        fillStack.amount = 1000 - (tank.getCapacity() - liquid.amount);
                        if (fillStack.amount > 0 && (used = this.fill(0, fillStack, false)) > 0) {
                            fillStack = tank.drain(used, true);
                            this.fill(0, fillStack, true);
                        }
                    }
                } else {
                    tankBelow = null;
                }
            }
            if (tankBelow != null && (available = this.tankManager.drain(0, 1000, false)) != null && available.amount > 0) {
                int used = tankBelow.fill(ForgeDirection.UP, available, true);
                this.tankManager.drain(0, used, true);
            }
        }
    }

    @Override
    public Icon getIcon(int side) {
        if (!this.isStructureValid() || this.getPattern() == null) {
            return this.getMachineType().getTexture(side);
        }
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        char markerSide = this.getPattern().getPatternMarkerChecked(MiscTools.getXOnSide(this.getPatternPositionX(), s), MiscTools.getYOnSide(this.getPatternPositionY(), s), MiscTools.getZOnSide(this.getPatternPositionZ(), s));
        if (!this.isMapPositionOtherBlock(markerSide)) {
            if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
                return this.getMachineType().getTexture(6);
            }
            return this.getMachineType().getTexture(7);
        }
        return this.getMachineType().getTexture(side);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (this.getPatternPositionY() - this.getPattern().getMasterOffsetY() > 1) {
            return null;
        }
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        TankManager tMan = this.getTankManager();
        if (tMan == null) {
            return 0;
        }
        int filled = tMan.fill(tankIndex, resource, doFill);
        if (filled > 0 && doFill) {
            this.setFilling(resource.copy());
        }
        return filled;
    }

    public ILiquidTank[] getTanks(ForgeDirection side) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return FakeTank.ARRAY;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return new IronTankWrapper((ILiquidTank)tMan.getTank(0));
        }
        return FakeTank.INSTANCE;
    }

    private class IronTankWrapper
    extends TankWrapper {
        public IronTankWrapper(ILiquidTank tank) {
            super(tank);
        }

        @Override
        public int fill(LiquidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            int filled = this.tank.fill(resource, doFill);
            if (filled > 0) {
                TileTankIronValve.this.setFilling(resource);
            }
            return filled;
        }

        @Override
        public LiquidStack drain(int maxDrain, boolean doDrain) {
            if (TileTankIronValve.this.getPatternPositionY() - TileTankIronValve.this.getPattern().getMasterOffsetY() > 1) {
                return null;
            }
            return this.tank.drain(maxDrain, doDrain);
        }

        @Override
        public int getTankPressure() {
            if (TileTankIronValve.this.getPatternPositionY() - TileTankIronValve.this.getPattern().getMasterOffsetY() > 1) {
                return 0;
            }
            return 1;
        }
    }
}

