/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileTankIron;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileTankIronGauge
extends TileTankIron {
    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.TANK_IRON_GAUGE;
    }

    @Override
    public Icon getIcon(int side) {
        if (!this.isStructureValid() || this.getPattern() == null) {
            return this.getTextureFromMachine(side);
        }
        int px = this.getPatternPositionX();
        int py = this.getPatternPositionY();
        int pz = this.getPatternPositionZ();
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        char markerSide = this.getPattern().getPatternMarkerChecked(MiscTools.getXOnSide(px, s), MiscTools.getYOnSide(py, s), MiscTools.getZOnSide(pz, s));
        if (!this.isMapPositionOtherBlock(markerSide)) {
            return this.getTextureFromMachine(9);
        }
        if (s == ForgeDirection.UP || s == ForgeDirection.DOWN) {
            char markerTop = this.getPattern().getPatternMarkerChecked(px, py + 1, pz);
            if (markerTop == 'A' || markerTop == 'O') {
                int metaUp = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
                int metaDown = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
                return this.getTextureBasedOnNeighbors(metaUp, metaDown);
            }
            return this.getTextureFromMachine(0);
        }
        int metaUp = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        int metaDown = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        return this.getTextureBasedOnNeighbors(metaUp, metaDown);
    }

    private Icon getTextureBasedOnNeighbors(int metaUp, int metaDown) {
        if (metaUp == this.func_70322_n() && metaDown == this.func_70322_n()) {
            return this.getTextureFromMachine(7);
        }
        if (metaUp == this.func_70322_n()) {
            return this.getTextureFromMachine(8);
        }
        if (metaDown == this.func_70322_n()) {
            return this.getTextureFromMachine(6);
        }
        return this.getTextureFromMachine(0);
    }

    private Icon getTextureFromMachine(int index) {
        return this.getMachineType().getTexture(index);
    }
}

