/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.BoilerFuelTank;
import mods.railcraft.common.liquids.tanks.FakeTank;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class TileBoilerFireboxLiquid
extends TileBoilerFirebox {
    private static final int TANK_FUEL = 2;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    protected final BoilerFuelTank tankFuel = new BoilerFuelTank(16000, this);

    public TileBoilerFireboxLiquid() {
        super(2);
        this.tankManager.addTank(this.tankFuel);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.BOILER_FIREBOX_LIQUID;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.BOILER_LIQUID, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleClick(EntityPlayer player) {
        if (LiquidManager.instance().handleRightClick(this, 2, player, true, false)) {
            return true;
        }
        return super.handleClick(player);
    }

    @Override
    protected void process() {
    }

    @Override
    protected void processBuckets() {
        super.processBuckets();
        LiquidManager.instance().processContainers(this, 2, this.inventory, 0, 1, true, false);
    }

    @Override
    protected float getMoreFuel() {
        LiquidStack fuel = this.tankManager.drain(2, 1000, false);
        if (fuel == null) {
            return 0.0f;
        }
        float heatValue = FuelManager.getBoilerFuelValue(fuel);
        if (heatValue > 0.0f) {
            this.tankManager.drain(2, 1000, true);
            if (fuel.amount < 1000) {
                heatValue *= (float)fuel.amount / 1000.0f;
            }
        }
        return heatValue;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (LiquidFilter.WATER.isLiquidEqual(resource)) {
            return this.fill(0, resource, doFill);
        }
        return this.fill(2, resource, doFill);
    }

    @Override
    public ILiquidTank getTank(ForgeDirection side, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            switch (side) {
                case DOWN: {
                    return new TileBoilerFirebox.WaterTankWrapper((ILiquidTank)tMan.getTank(0));
                }
            }
            return tMan.getTank(2);
        }
        return FakeTank.INSTANCE;
    }

    public boolean func_94042_c() {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                LiquidStack liquid = LiquidManager.instance().getLiquidInContainer(stack);
                if (liquid == null) {
                    return false;
                }
                if (!LiquidFilter.WATER.isLiquidEqual(liquid) && FuelManager.getBoilerFuelValue(liquid) <= 0) break;
                return true;
            }
        }
        return false;
    }
}

