/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.beta.ISteamUser;
import mods.railcraft.common.blocks.machine.beta.TileBoiler;
import mods.railcraft.common.gui.elements.IIndicatorController;
import mods.railcraft.common.gui.elements.IndicatorController;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.LiquidItems;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.TankWrapper;
import mods.railcraft.common.liquids.tanks.FakeTank;
import mods.railcraft.common.plugins.buildcraft.triggers.ITemperature;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public abstract class TileBoilerFirebox
extends TileBoiler
implements IInventory,
ISidedInventory,
ITemperature {
    protected static final int SLOT_LIQUID_INPUT = 0;
    protected static final int SLOT_LIQUID_OUTPUT = 1;
    public float heat = 20.0f;
    private byte burnCycle;
    public float burnTime;
    private boolean burning = false;
    public float currentItemBurnTime;
    private boolean wasLit;
    private byte prevPattern;
    protected final StandaloneInventory inventory;
    protected IInventory invWaterInput = new InventoryMapper(this, 0, 1);
    protected IInventory invWaterOutput = new InventoryMapper(this, 1, 1);
    private IIndicatorController heatIndicator = new HeatIndicator();

    public IIndicatorController getHeatIndicator() {
        return this.heatIndicator;
    }

    protected TileBoilerFirebox(int invSize) {
        this.inventory = new StandaloneInventory(invSize, this);
    }

    @Override
    public Icon getIcon(int side) {
        if (side > 1 && this.isBurning()) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    protected void onPatternLock(MultiBlockPattern pattern) {
        int capacity = this.getNumTanks() * 1000;
        this.tankManager.setCapacity(1, capacity * this.getSteamCapacityPerTank());
        this.tankManager.setCapacity(0, capacity * 4);
        byte newPattern = this.getPatternIndex();
        if (newPattern != this.prevPattern) {
            this.heat = 20.0f;
        }
        this.prevPattern = newPattern;
    }

    public int getBurnProgressScaled(int i) {
        if (!this.isBurning()) {
            return 0;
        }
        int scale = (int)(this.burnTime / this.currentItemBurnTime * (float)i);
        scale = Math.max(0, scale);
        scale = Math.min(i, scale);
        return scale;
    }

    public boolean isBurning() {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock == null) {
            return false;
        }
        return mBlock.burning;
    }

    protected void updateLighting() {
        boolean b = this.isBurning();
        if (this.wasLit != b) {
            this.wasLit = b;
            this.field_70331_k.func_72936_c(EnumSkyBlock.Block, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.markBlockForUpdate();
        }
    }

    @Override
    public int getLightValue() {
        if (this.isStructureValid() && this.isBurning()) {
            return 13;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random random) {
        if (this.isStructureValid()) {
            this.updateLighting();
            if (this.isBurning() && random.nextInt(100) < 20) {
                float f = (float)this.field_70329_l + 0.5f;
                float f1 = (float)this.field_70330_m + 0.4375f + random.nextFloat() * 3.0f / 16.0f;
                float f2 = (float)this.field_70327_n + 0.5f;
                float f3 = 0.52f;
                float f4 = random.nextFloat() * 0.6f - 0.3f;
                this.field_70331_k.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                this.field_70331_k.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                this.field_70331_k.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                this.field_70331_k.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public ITileFilter getOutputFilter() {
        return ISteamUser.FILTER;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.isMaster) {
            this.process();
            int numTanks = this.getNumTanks();
            this.burnCycle = (byte)(this.burnCycle + 1);
            int ticks = this.getTicksPerConversion();
            if (this.burnCycle >= ticks) {
                LiquidStack steam;
                int waterCost;
                LiquidStack water;
                boolean addedFuel;
                this.burnCycle = 0;
                float fuelNeeded = this.getFuelPerConversion(numTanks) * (float)numTanks;
                while (this.burnTime < fuelNeeded && (addedFuel = this.addFuel())) {
                }
                boolean wasBurning = this.burning;
                if (this.burnTime < fuelNeeded) {
                    this.burning = false;
                } else {
                    this.burnTime -= fuelNeeded;
                    this.burning = true;
                }
                if (this.burning != wasBurning) {
                    this.sendUpdateToClient();
                }
                if (this.heat >= 100.0f && (water = this.tankManager.drain(0, waterCost = numTanks, false)) != null && (steam = LiquidItems.getSteamLiquid(160 * (waterCost = Math.min(waterCost, water.amount)))) != null) {
                    this.tankManager.drain(0, waterCost, true);
                    this.tankManager.fill(1, steam, true);
                }
            }
            if (this.isBurning()) {
                this.increaseHeat(numTanks);
            } else {
                this.reduceHeat(numTanks);
            }
            if (this.update % 8 == 0) {
                this.processBuckets();
            }
        }
    }

    private boolean addFuel() {
        float fuel = this.getMoreFuel();
        this.burnTime += fuel;
        this.currentItemBurnTime = this.burnTime;
        return fuel > 0.0f;
    }

    protected abstract void process();

    protected abstract float getMoreFuel();

    protected void processBuckets() {
        LiquidManager.instance().processContainers(this, 0, this.inventory, 0, 1, true, false);
    }

    public float getFuelPerConversion(int numTanks) {
        float fuel = 6.4f - (float)numTanks * 0.08f;
        fuel += fuel * (8.0f - 8.0f * this.getHeatLevel());
        return fuel;
    }

    public float getHeatLevel() {
        return this.heat / this.getMaxHeat();
    }

    private void increaseHeat(int numTanks) {
        float heatLevel = this.getHeatLevel();
        float change = 0.05f;
        if (heatLevel < 0.25f) {
            change += 0.05f;
        }
        if (heatLevel < 0.5f) {
            change += 0.05f;
        }
        if (heatLevel < 0.75f) {
            change += 0.05f;
        }
        this.heat += (change /= (float)numTanks);
        this.heat = Math.min(this.heat, this.getMaxHeat());
    }

    private void reduceHeat(int numTanks) {
        float heatLevel = this.getHeatLevel();
        float change = 0.05f;
        if (heatLevel > 0.25f) {
            change += 0.05f;
        }
        if (heatLevel > 0.5f) {
            change += 0.05f;
        }
        if (heatLevel > 0.75f) {
            change += 0.05f;
        }
        this.heat -= (change /= (float)numTanks);
        this.heat = Math.max(this.heat, 20.0f);
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
        InvTools.dropInventory(this.inventory, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.tankManager.getTank(1).setLiquid(null);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeTanksToNBT(data);
        this.inventory.writeToNBT("inv", data);
        data.func_74776_a("heat", this.heat);
        data.func_74776_a("burnTime", this.burnTime);
        data.func_74776_a("currentItemBurnTime", this.currentItemBurnTime);
        data.func_74774_a("prevPattern", this.prevPattern);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.tankManager.readTanksFromNBT(data);
        this.inventory.readFromNBT("inv", data);
        this.heat = data.func_74760_g("heat");
        this.burnTime = data.func_74760_g("burnTime");
        this.currentItemBurnTime = data.func_74760_g("currentItemBurnTime");
        this.prevPattern = data.func_74771_c("prevPattern");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
        data.writeBoolean(this.burning);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
        this.burning = data.readBoolean();
    }

    public ItemStack func_70298_a(int i, int j) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inventory.func_70298_a(i, j);
        }
        return null;
    }

    public ItemStack func_70301_a(int i) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inventory.func_70301_a(i);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.inventory.func_70299_a(i, itemstack);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    protected boolean handleClick(EntityPlayer player) {
        return LiquidManager.instance().handleRightClick(this, 0, player, true, false);
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    @Override
    public float getTemperature() {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.heat;
        }
        return 20.0f;
    }

    public ILiquidTank getTank(ForgeDirection side, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return new WaterTankWrapper((ILiquidTank)tMan.getTank(0));
        }
        return FakeTank.INSTANCE;
    }

    protected class WaterTankWrapper
    extends TankWrapper {
        public WaterTankWrapper(ILiquidTank tank) {
            super(tank);
        }

        @Override
        public int fill(LiquidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            if (doFill && LiquidFilter.WATER.isLiquidEqual(resource)) {
                TileBoilerFirebox.this.onFillWater();
            }
            return this.tank.fill(resource, doFill);
        }
    }

    private class HeatIndicator
    extends IndicatorController {
        private HeatIndicator() {
        }

        @Override
        protected void refreshToolTip() {
            this.tip.text = String.format("%.0f\u00b0C", Float.valueOf(TileBoilerFirebox.this.heat));
        }

        @Override
        public int getScaledLevel(int size) {
            return (int)((TileBoilerFirebox.this.heat - 20.0f) * (float)size / (TileBoilerFirebox.this.getMaxHeat() - 20.0f));
        }
    }
}

