/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.FakeTank;
import mods.railcraft.common.liquids.tanks.FilteredTank;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public abstract class TileBoiler
extends TileMultiBlock
implements ITankContainer {
    private static final Set boilerBlocks = new HashSet();
    private static final Set fireboxBlocks = new HashSet();
    private static final List patterns = new ArrayList();
    public static final int TANK_WATER = 0;
    public static final int TANK_STEAM = 1;
    public static final int TRANSFER_RATE = 80;
    public static final int TICKS_LOW = 16;
    public static final int TICKS_HIGH = 8;
    public static final int STEAM_LOW = 16;
    public static final int STEAM_HIGH = 32;
    public static final float HEAT_LOW = 500.0f;
    public static final float HEAT_HIGH = 1000.0f;
    protected final TankManager tankManager = new TankManager();
    protected final FilteredTank tankWater = new FilteredTank(4000, LiquidFilter.WATER, this);
    protected final FilteredTank tankSteam;

    private static MultiBlockPattern buildMap(int width, int tankHeight, char tank, int ticks, float heat, int capacity) {
        int z;
        int x;
        char[][][] map = new char[tankHeight + 3][width + 2][width + 2];
        for (x = 0; x < width + 2; ++x) {
            for (z = 0; z < width + 2; ++z) {
                map[0][x][z] = 79;
            }
        }
        for (x = 0; x < width + 2; ++x) {
            for (z = 0; z < width + 2; ++z) {
                int m;
                map[1][x][z] = m = x == 0 || z == 0 || x == width + 1 || z == width + 1 ? 79 : 70;
            }
        }
        for (int y = 2; y < tankHeight + 2; ++y) {
            for (int x2 = 0; x2 < width + 2; ++x2) {
                for (int z2 = 0; z2 < width + 2; ++z2) {
                    int m;
                    map[y][x2][z2] = m = x2 == 0 || z2 == 0 || x2 == width + 1 || z2 == width + 1 ? 79 : (int)tank;
                }
            }
        }
        for (x = 0; x < width + 2; ++x) {
            for (z = 0; z < width + 2; ++z) {
                map[tankHeight + 2][x][z] = 79;
            }
        }
        return new BoilerPattern(map, width * width * tankHeight, ticks, heat, capacity);
    }

    protected TileBoiler() {
        super(patterns);
        this.tankManager.addTank(this.tankWater);
        this.tankSteam = new FilteredTank(16000, LiquidFilter.STEAM, this);
        this.tankSteam.setTankPressure(1);
        this.tankManager.addTank(this.tankSteam);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        TileBoilerFirebox mBlock;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.field_77993_c != Item.field_77788_aw.field_77779_bT && (Game.isHost(this.field_70331_k) ? (mBlock = (TileBoilerFirebox)this.getMasterBlock()) != null && mBlock.handleClick(player) : LiquidManager.instance().isContainer(current))) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    public void explode() {
        if (Game.isHost(this.field_70331_k)) {
            this.field_70331_k.func_72876_a(null, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, 5.0f + 0.1f * (float)this.getNumTanks(), true);
        }
    }

    public int getNumTanks() {
        MultiBlockPattern pattern = this.getPattern();
        return ((BoilerPattern)pattern).numTanks;
    }

    public float getMaxHeat() {
        MultiBlockPattern pattern = this.getPattern();
        return ((BoilerPattern)pattern).maxHeat;
    }

    public int getTicksPerConversion() {
        MultiBlockPattern pattern = this.getPattern();
        return ((BoilerPattern)pattern).ticksPerConversion;
    }

    public int getSteamCapacityPerTank() {
        MultiBlockPattern pattern = this.getPattern();
        return ((BoilerPattern)pattern).steamCapacity;
    }

    public TankManager getTankManager() {
        TileBoiler mBlock = (TileBoiler)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public void func_70316_g() {
        StandardTank tank;
        LiquidStack steam;
        TileBoilerFirebox mBlock;
        super.func_70316_g();
        if (Game.isHost(this.field_70331_k) && (mBlock = (TileBoilerFirebox)this.getMasterBlock()) != null && (steam = (tank = mBlock.tankManager.getTank(1)).getLiquid()) != null && (mBlock.heat < 100.0f || steam.amount >= tank.getCapacity() / 2)) {
            mBlock.tankManager.outputLiquid(this.tileCache, this.getOutputFilter(), ForgeDirection.VALID_DIRECTIONS, 1, 80);
        }
    }

    public abstract ITileFilter getOutputFilter();

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.openGui(player);
        }
        return false;
    }

    @Override
    protected int getMaxRecursionDepth() {
        return 20;
    }

    @Override
    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        int id = this.field_70331_k.func_72798_a(i, j, k);
        int meta = this.field_70331_k.func_72805_g(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (id != this.getBlockId() || !boilerBlocks.contains(meta)) break;
                return false;
            }
            case 'L': {
                if (id == this.getBlockId() && meta == EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal()) break;
                return false;
            }
            case 'H': {
                if (id == this.getBlockId() && meta == EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal()) break;
                return false;
            }
            case 'F': {
                if (id == this.getBlockId() && meta == this.func_70322_n() && fireboxBlocks.contains(meta)) break;
                return false;
            }
            case 'A': {
                if (this.field_70331_k.func_72799_c(i, j, k)) break;
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isStructureTile(TileEntity tile) {
        return tile instanceof TileBoiler;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(1, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock == null) {
            return null;
        }
        return mBlock.tankManager.drain(tankIndex, maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex == 1) {
            return 0;
        }
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock == null) {
            return 0;
        }
        if (doFill && LiquidFilter.WATER.isLiquidEqual(resource)) {
            this.onFillWater();
        }
        return mBlock.tankManager.fill(tankIndex, resource, doFill);
    }

    protected void onFillWater() {
        LiquidStack water;
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null && mBlock.heat >= 300.0f && ((water = mBlock.tankManager.getTank(0).getLiquid()) == null || water.amount <= 0)) {
            mBlock.heat = 299.0f;
            this.explode();
        }
    }

    public ILiquidTank[] getTanks(ForgeDirection dir) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager.getTanks();
        }
        return FakeTank.ARRAY;
    }

    static {
        fireboxBlocks.add(EnumMachineBeta.BOILER_FIREBOX_SOLID.ordinal());
        fireboxBlocks.add(EnumMachineBeta.BOILER_FIREBOX_LIQUID.ordinal());
        boilerBlocks.addAll(fireboxBlocks);
        boilerBlocks.add(EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal());
        boilerBlocks.add(EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal());
        patterns.add(TileBoiler.buildMap(3, 4, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(3, 3, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(3, 2, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(2, 3, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(2, 2, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(1, 1, 'H', 8, 1000.0f, 32));
        patterns.add(TileBoiler.buildMap(3, 4, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(3, 3, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(3, 2, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(2, 3, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(2, 2, 'L', 16, 500.0f, 16));
        patterns.add(TileBoiler.buildMap(1, 1, 'L', 16, 500.0f, 16));
    }

    public static class BoilerPattern
    extends MultiBlockPattern {
        public final int numTanks;
        public final int ticksPerConversion;
        public final float maxHeat;
        public final int steamCapacity;

        public BoilerPattern(char[][][] pattern, int tanks, int ticks, float heat, int capacity) {
            super(pattern, 1, 1, 1);
            this.numTanks = tanks;
            this.ticksPerConversion = ticks;
            this.maxHeat = heat;
            this.steamCapacity = capacity;
        }
    }
}

