/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileTank;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.slots.SlotWaterOrEmpty;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.FilteredTank;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileTankWater
extends TileTank
implements ISidedInventory {
    private static final int OUTPUT_RATE = 40;
    private static final int TANK_CAPACITY = 400000;
    private static final int REFILL_INTERVAL = 8;
    private static final float REFILL_RATE = 10.0f;
    private static final float REFILL_PENALTY_INSIDE = 0.5f;
    private static final float REFILL_PENALTY_SNOW = 0.5f;
    private static final float REFILL_BOOST_RAIN = 3.0f;
    private static final byte REFILL_RATE_MIN = 1;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    private static final ForgeDirection[] LIQUID_OUTPUTS = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH};
    private static final ITileFilter LIQUID_OUTPUT_FILTER = new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            if (tile instanceof TileTank) {
                return false;
            }
            return tile instanceof ITankContainer;
        }
    };
    private static final List patterns = new ArrayList();
    private IInventory invInput = new InventoryMapper(this, 0, 1);
    private IInventory invOutput = new InventoryMapper(this, 1, 1);

    public TileTankWater() {
        super("gui.tank.water", 2, patterns);
        FilteredTank tank = new FilteredTank(400000, new LiquidStack(Block.field_71943_B, 0), this);
        tank.setTankPressure(1);
        this.tankManager.addTank(tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.TANK_WATER;
    }

    @Override
    public String getTitle() {
        return RailcraftLanguage.translate("gui.tank.water");
    }

    @Override
    public Slot getInputSlot(IInventory inv, int id, int x, int y) {
        return new SlotWaterOrEmpty(inv, id, x, y);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        if (Game.isHost(this.field_70331_k) ? this.isStructureValid() && LiquidManager.instance().handleRightClick(this.getTankManager(), 0, player, true, true) : LiquidManager.instance().isContainer(player.field_71071_by.func_70448_g())) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isHost(this.getWorld())) {
            TankManager tMan;
            if (this.isMaster()) {
                if (this.field_70331_k.field_73011_w.field_76574_g != -1 && this.update % 8 == 0) {
                    float rate = 10.0f;
                    BiomeGenBase biome = this.field_70331_k.func_72807_a(this.field_70329_l, this.field_70327_n);
                    float humidity = biome.field_76751_G;
                    rate *= humidity;
                    boolean outside = false;
                    for (int x = this.field_70329_l; x < this.field_70329_l + 3; ++x) {
                        for (int z = this.field_70327_n; z < this.field_70327_n + 3 && !(outside = this.field_70331_k.func_72937_j(x, this.field_70330_m + 3, z)); ++z) {
                        }
                    }
                    if (!outside) {
                        rate *= 0.5f;
                    } else if (this.field_70331_k.func_72896_J()) {
                        rate = biome.func_76746_c() ? (rate *= 0.5f) : (rate *= 3.0f);
                    }
                    int rateFinal = MathHelper.func_76141_d((float)rate);
                    if (rateFinal < 1) {
                        rateFinal = 1;
                    }
                    LiquidStack fillStack = new LiquidStack(Block.field_71943_B, rateFinal);
                    this.fill(0, fillStack, true);
                }
                if (this.update % 8 == 0) {
                    LiquidManager.instance().processContainers(this.tankManager.getTank(0), this, 0, 1);
                }
            }
            if ((tMan = this.getTankManager()) != null) {
                tMan.outputLiquid(this.tileCache, LIQUID_OUTPUT_FILTER, LIQUID_OUTPUTS, 0, 40);
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.TANK, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon(int side) {
        return EnumMachineAlpha.TANK_WATER.getTexture(side);
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.UP) {
            return 0;
        }
        return this.fill(0, resource, doFill);
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex != 0 || resource == null || resource.itemID != Block.field_71943_B.field_71990_ca) {
            return 0;
        }
        return super.fill(tankIndex, resource, doFill);
    }

    @Override
    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                LiquidManager lm = LiquidManager.instance();
                return lm.isEmptyContainer(stack) || lm.containsLiquid(stack, LiquidFilter.WATER);
            }
        }
        return false;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

