/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.gates.IAction;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockInventory;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.ISteamUser;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.FakeTank;
import mods.railcraft.common.liquids.tanks.FilteredTank;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileSteamOven
extends TileMultiBlockInventory
implements ITankContainer,
ISidedInventory,
ISteamUser,
IHasWork {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    private static final int STEAM_PER_BATCH = 8000;
    private static final int TOTAL_COOK_TIME = 256;
    private static final int COOK_STEP = 16;
    private static final int ITEMS_SMELTED = 9;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 9;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    private static final int TANK_CAPACITY = 8000;
    private static final List patterns = new ArrayList();
    private ForgeDirection facing = ForgeDirection.NORTH;
    public int cookTime;
    public boolean finishedCycle = false;
    private boolean paused = false;
    private final TankManager tankManager = new TankManager();
    private final StandardTank tank;
    private IInventory invInput = new InventoryMapper(this, 0, 9);
    private IInventory invOutput = new InventoryMapper(this, 9, 9, false);
    private final Set actions = new HashSet();

    public TileSteamOven() {
        super("gui.steam.oven", 18, patterns);
        this.tank = new FilteredTank(8000, LiquidFilter.STEAM, this);
        this.tankManager.addTank(this.tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.STEAM_OVEN;
    }

    public TankManager getTankManager() {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public Icon getIcon(int side) {
        if (this.isStructureValid() && side == this.getFacing().ordinal()) {
            switch (side) {
                case 2: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionX() == 2) {
                            return this.getMachineType().getTexture(6);
                        }
                        return this.getMachineType().getTexture(7);
                    }
                    if (this.getPatternPositionX() == 2) {
                        return this.getMachineType().getTexture(8);
                    }
                    return this.getMachineType().getTexture(9);
                }
                case 3: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionX() == 1) {
                            return this.getMachineType().getTexture(6);
                        }
                        return this.getMachineType().getTexture(7);
                    }
                    if (this.getPatternPositionX() == 1) {
                        return this.getMachineType().getTexture(8);
                    }
                    return this.getMachineType().getTexture(9);
                }
                case 4: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionZ() == 1) {
                            return this.getMachineType().getTexture(6);
                        }
                        return this.getMachineType().getTexture(7);
                    }
                    if (this.getPatternPositionZ() == 1) {
                        return this.getMachineType().getTexture(8);
                    }
                    return this.getMachineType().getTexture(9);
                }
                case 5: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionZ() == 2) {
                            return this.getMachineType().getTexture(6);
                        }
                        return this.getMachineType().getTexture(7);
                    }
                    if (this.getPatternPositionZ() == 2) {
                        return this.getMachineType().getTexture(8);
                    }
                    return this.getMachineType().getTexture(9);
                }
            }
        }
        if (side > 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(0);
    }

    public int getCookProgressScaled(int i) {
        int scale = this.getCookTime() * i / 256;
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    public int getCookTime() {
        TileSteamOven masterOven = (TileSteamOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.cookTime;
        }
        return -1;
    }

    public ForgeDirection getFacing() {
        TileSteamOven masterOven = (TileSteamOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.facing;
        }
        return this.facing;
    }

    public boolean hasFinishedCycle() {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        return mBlock != null && mBlock.finishedCycle;
    }

    public void setHasFinishedCycle(boolean finished) {
        if (this.finishedCycle != finished) {
            this.finishedCycle = finished;
            this.sendUpdateToClient();
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            if (this.hasFinishedCycle()) {
                EffectManager.instance.steamEffect(this.field_70331_k, this, 0.25);
            }
            return;
        }
        if (this.isMaster()) {
            if (this.update % 16 == 0) {
                this.processActions();
            }
            if (this.update % 16 == 0) {
                this.setHasFinishedCycle(false);
                if (!this.paused) {
                    if (this.hasRecipe()) {
                        if (this.cookTime <= 0 && this.drainSteam()) {
                            this.cookTime = 1;
                        } else if (this.cookTime > 0) {
                            this.cookTime += 16;
                            if (this.cookTime >= 256 && this.smeltItems()) {
                                this.cookTime = 0;
                                this.setHasFinishedCycle(true);
                                SoundHelper.playSound(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, "machine.steamburst", 1.0f, (float)(1.0 + MiscTools.getRand().nextGaussian() * 0.1));
                            }
                        }
                    } else {
                        this.cookTime = 0;
                    }
                }
            }
        }
    }

    private boolean drainSteam() {
        LiquidStack steam = this.tank.drain(8000, false);
        if (steam != null && steam.amount >= 8000) {
            this.tank.drain(8000, true);
            return true;
        }
        return false;
    }

    private boolean hasRecipe() {
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack stack = this.invInput.func_70301_a(slot);
            if (stack == null || FurnaceRecipes.func_77602_a().getSmeltingResult(stack) == null) continue;
            return true;
        }
        return false;
    }

    private boolean smeltItems() {
        int count = 0;
        boolean changed = true;
        boolean smelted = false;
        while (count < 9 && changed) {
            changed = false;
            for (int slot = 0; slot < 9 && count < 9; ++slot) {
                ItemStack remainder;
                ItemStack output;
                ItemStack stack = this.invInput.func_70301_a(slot);
                if (stack == null || (output = FurnaceRecipes.func_77602_a().getSmeltingResult(stack)) == null || !InvTools.isRoomForStack(output, this.invOutput) || (remainder = InvTools.moveItemStack(output.func_77946_l(), this.invOutput)) != null) continue;
                this.invInput.func_70298_a(slot, 1);
                changed = true;
                ++count;
            }
            smelted |= changed;
        }
        return smelted;
    }

    @Override
    public void onBlockPlacedBy(EntityLiving player) {
        super.onBlockPlacedBy(player);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, player);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        TileSteamOven master = (TileSteamOven)this.getMasterBlock();
        if (master != null) {
            master.facing = master.facing == axis ? axis.getOpposite() : axis;
            master.scheduleMasterRetest();
            return true;
        }
        return false;
    }

    @Override
    public ForgeDirection[] getValidRotations() {
        return UP_DOWN_AXES;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null) {
            GuiHandler.openGui(EnumGui.STEAN_OVEN, player, this.field_70331_k, masterBlock.field_70329_l, masterBlock.field_70330_m, masterBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeTanksToNBT(data);
        data.func_74768_a("cookTime", this.cookTime);
        data.func_74774_a("facing", (byte)this.facing.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.tankManager.readTanksFromNBT(data);
        this.cookTime = data.func_74762_e("cookTime");
        this.facing = ForgeDirection.getOrientation((int)data.func_74771_c("facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.facing.ordinal());
        data.writeBoolean(this.finishedCycle);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte f = data.readByte();
        this.finishedCycle = data.readBoolean();
        if (f != this.facing.ordinal()) {
            this.facing = ForgeDirection.getOrientation((int)f);
            this.markBlockForUpdate();
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        TankManager tMan = this.getTankManager();
        if (tMan == null) {
            return 0;
        }
        return tMan.fill(tankIndex, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection dir) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return FakeTank.ARRAY;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTank(0);
        }
        return FakeTank.INSTANCE;
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return slot >= 9;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (slot >= 9) {
            return false;
        }
        return FurnaceRecipes.func_77602_a().getSmeltingResult(stack) != null;
    }

    @Override
    public boolean hasWork() {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.cookTime > 0;
        }
        return false;
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IAction action) {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.actions.add(action);
        }
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

