/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.post.BlockPost;
import mods.railcraft.common.blocks.signals.BlockSignal;
import mods.railcraft.common.blocks.signals.TileSignalBase;
import mods.railcraft.common.util.misc.FakeBlockRenderInfo;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;

public class RenderSignal
implements ICombinedRenderer {
    private SignalAspect defaultAspect;
    private FakeBlockRenderInfo info = new FakeBlockRenderInfo();

    public RenderSignal(SignalAspect defaultAspect) {
        this.defaultAspect = defaultAspect;
        this.info.template = RailcraftBlocks.getBlockSignal();
        this.info.texture = new Icon[6];
    }

    @Override
    public void renderBlock(RenderBlocks renderblocks, IBlockAccess iBlockAccess, int x, int y, int z, Block block) {
        float f7;
        float size;
        TileSignalBase tile = (TileSignalBase)iBlockAccess.func_72796_p(x, y, z);
        if (tile == null) {
            return;
        }
        float pix = 0.0625f;
        int facing = tile.getFacing().ordinal();
        float min = 3.0f * pix;
        float max = 13.0f * pix;
        this.info.setBlockBounds(min, 6.0f * pix, min, max, 1.0f, max);
        this.info.texture[0] = BlockSignal.texturesSignalSingle[0];
        this.info.texture[1] = BlockSignal.texturesSignalSingle[0];
        this.info.texture[2] = BlockSignal.texturesSignalSingle[1];
        this.info.texture[3] = BlockSignal.texturesSignalSingle[1];
        this.info.texture[4] = BlockSignal.texturesSignalSingle[1];
        this.info.texture[5] = BlockSignal.texturesSignalSingle[1];
        this.info.texture[facing] = BlockSignal.texturesSignalSingle[2];
        RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        SignalAspect aspect = tile.getSignalAspect();
        if (!aspect.isLit()) {
            aspect = SignalAspect.OFF;
        }
        this.info.texture[facing] = BlockSignal.texturesLampTop[aspect.getTextureIndex()];
        this.info.setRenderSingleSide(facing);
        this.info.brightness = aspect.getTextureBrightness();
        RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, this.info.brightness < 0, false);
        this.info.brightness = -1;
        this.info.setRenderAllSides();
        this.info.texture[facing] = BlockSignal.texturesSignalSingle[2];
        if (facing == 2 || facing == 3) {
            size = 13.0f * pix;
            if (facing == 2) {
                size = pix;
            }
            this.info.setBlockBounds(6.0f * pix, 13.0f * pix, size, 10.0f * pix, 14.0f * pix, size + 2.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            this.info.setBlockBounds(5.0f * pix, 10.0f * pix, size, 6.0f * pix, 14.0f * pix, size + 2.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            this.info.setBlockBounds(10.0f * pix, 10.0f * pix, size, 11.0f * pix, 14.0f * pix, size + 2.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        } else if (facing == 4 || facing == 5) {
            size = 13.0f * pix;
            if (facing == 4) {
                size = pix;
            }
            this.info.setBlockBounds(size, 13.0f * pix, 6.0f * pix, size + 2.0f * pix, 14.0f * pix, 10.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            this.info.setBlockBounds(size, 10.0f * pix, 5.0f * pix, size + 2.0f * pix, 14.0f * pix, 6.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            this.info.setBlockBounds(size, 10.0f * pix, 10.0f * pix, size + 2.0f * pix, 14.0f * pix, 11.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        this.info.texture[0] = BlockSignal.texturesSignalSingle[3];
        this.info.texture[1] = BlockSignal.texturesSignalSingle[3];
        this.info.texture[2] = BlockSignal.texturesSignalSingle[4];
        this.info.texture[3] = BlockSignal.texturesSignalSingle[4];
        this.info.texture[4] = BlockSignal.texturesSignalSingle[4];
        this.info.texture[5] = BlockSignal.texturesSignalSingle[4];
        min = 6.0f * pix;
        max = 10.0f * pix;
        Block below = Block.field_71973_m[iBlockAccess.func_72798_a(x, y - 1, z)];
        World world = Game.getWorld();
        if (BlockPost.connectPostAt(world, x, y - 1, z, ForgeDirection.UP) || below != null && (below.isBlockSolidOnSide(Game.getWorld(), x, y - 1, z, ForgeDirection.UP) || below.canPlaceTorchOnTop(world, x, y - 1, z))) {
            this.info.setBlockBounds(min, 0.0f, min, max, 15.0f * pix, max);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        boolean flag1 = false;
        boolean flag2 = false;
        if (BlockPost.connectPostAt(world, x - 1, y, z, ForgeDirection.EAST) || BlockPost.connectPostAt(world, x + 1, y, z, ForgeDirection.WEST)) {
            flag1 = true;
        }
        if (BlockPost.connectPostAt(world, x, y, z - 1, ForgeDirection.SOUTH) || BlockPost.connectPostAt(world, x, y, z + 1, ForgeDirection.NORTH)) {
            flag2 = true;
        }
        boolean flag3 = BlockPost.connectPostAt(world, x - 1, y, z, ForgeDirection.EAST);
        boolean flag4 = BlockPost.connectPostAt(world, x + 1, y, z, ForgeDirection.WEST);
        boolean flag5 = BlockPost.connectPostAt(world, x, y, z - 1, ForgeDirection.SOUTH);
        boolean flag6 = BlockPost.connectPostAt(world, x, y, z + 1, ForgeDirection.NORTH);
        if (!flag1 && !flag2) {
            flag1 = true;
        }
        float f = 0.4375f;
        float f1 = 0.5625f;
        float f2 = 11.0f * pix;
        float f3 = 14.0f * pix;
        float f4 = flag3 ? 0.0f : f;
        float f5 = flag4 ? 1.0f : f1;
        float f6 = flag5 ? 0.0f : f;
        float f8 = f7 = flag6 ? 1.0f : f1;
        if (flag1) {
            this.info.setBlockBounds(f4, f2, f, f5, f3, f1);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        if (flag2) {
            this.info.setBlockBounds(f, f2, f6, f1, f3, f7);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        f2 = 5.0f * pix;
        f3 = 8.0f * pix;
        if (flag1) {
            this.info.setBlockBounds(f4, f2, f, f5, f3, f1);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        if (flag2) {
            this.info.setBlockBounds(f, f2, f6, f1, f3, f7);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        float pix = 0.0625f;
        float min = 6.0f * pix;
        float max = 10.0f * pix;
        this.info.texture[0] = BlockSignal.texturesSignalSingle[3];
        this.info.texture[1] = BlockSignal.texturesSignalSingle[3];
        this.info.texture[2] = BlockSignal.texturesSignalSingle[4];
        this.info.texture[3] = BlockSignal.texturesSignalSingle[4];
        this.info.texture[4] = BlockSignal.texturesSignalSingle[4];
        this.info.texture[5] = BlockSignal.texturesSignalSingle[4];
        this.info.setBlockBounds(min, 0.0f, min, max, 15.0f * pix, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.texture[0] = BlockSignal.texturesSignalSingle[0];
        this.info.texture[1] = BlockSignal.texturesSignalSingle[0];
        this.info.texture[2] = BlockSignal.texturesSignalSingle[1];
        this.info.texture[3] = BlockSignal.texturesSignalSingle[2];
        this.info.texture[4] = BlockSignal.texturesSignalSingle[1];
        this.info.texture[5] = BlockSignal.texturesSignalSingle[1];
        min = 3.0f * pix;
        max = 13.0f * pix;
        this.info.setBlockBounds(min, 6.0f * pix, min, max, 1.0f, max);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.texture[3] = BlockSignal.texturesLampTop[this.defaultAspect.getTextureIndex()];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f, 3);
        this.info.texture[3] = BlockSignal.texturesSignalSingle[2];
        float size = 13.0f * pix;
        this.info.setBlockBounds(6.0f * pix, 13.0f * pix, size, 10.0f * pix, 14.0f * pix, size + 2.0f * pix);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(5.0f * pix, 10.0f * pix, size, 6.0f * pix, 14.0f * pix, size + 2.0f * pix);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setBlockBounds(10.0f * pix, 10.0f * pix, size, 11.0f * pix, 14.0f * pix, size + 2.0f * pix);
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
    }
}

