/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.lib.Element;
import extrabiomes.lib.GeneralSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockGreenLeaves
extends BlockLeavesBase
implements IShearable {
    private static final int METADATA_BITMASK = 3;
    private static final int METADATA_USERPLACEDBIT = 4;
    private static final int METADATA_DECAYBIT = 8;
    private static final int METADATA_CLEARDECAYBIT = -9;
    int[] adjacentTreeBlocks;
    private Icon[] textures = new Icon[]{null, null, null, null, null, null, null, null};

    private static int calcSmoothedBiomeFoliageColor(IBlockAccess iBlockAccess, int x, int z) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int z1 = -1; z1 <= 1; ++z1) {
            for (int x1 = -1; x1 <= 1; ++x1) {
                int foliageColor = iBlockAccess.func_72807_a(x + x1, z + z1).func_76726_l();
                red += (foliageColor & 0xFF0000) >> 16;
                green += (foliageColor & 0xFF00) >> 8;
                blue += foliageColor & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
    }

    private static int clearDecayOnMetadata(int metadata) {
        return metadata & 0xFFFFFFF7;
    }

    private static boolean isDecaying(int metadata) {
        return (metadata & 8) != 0;
    }

    private static boolean isUserPlaced(int metadata) {
        return (metadata & 4) != 0;
    }

    private static int setDecayOnMetadata(int metadata) {
        return metadata | 8;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 3;
    }

    public BlockGreenLeaves(int id, Material material, boolean useFastGraphics) {
        super(id, material, useFastGraphics);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.textures[0] = iconRegister.func_94245_a("ExtrabiomesXL:leavesfirfancy");
        this.textures[1] = iconRegister.func_94245_a("ExtrabiomesXL:leavesfirfast");
        this.textures[2] = iconRegister.func_94245_a("ExtrabiomesXL:leavesredwoodfancy");
        this.textures[3] = iconRegister.func_94245_a("ExtrabiomesXL:leavesredwoodfast");
        this.textures[4] = iconRegister.func_94245_a("ExtrabiomesXL:leavesacaciafancy");
        this.textures[5] = iconRegister.func_94245_a("ExtrabiomesXL:leavesacaciafast");
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, BlockGreenLeaves.setDecayOnMetadata(world.func_72805_g(x, y, z)), 3);
    }

    public void func_71852_a(World world, int x, int y, int z, int BlockID, int metadata) {
        boolean leafDecayRadius = true;
        int chuckCheckRadius = 2;
        if (!world.func_72904_c(x - 2, y - 2, z - 2, x + 2, y + 2, z + 2)) {
            return;
        }
        for (int x1 = -1; x1 <= 1; ++x1) {
            for (int y1 = -1; y1 <= 1; ++y1) {
                for (int z1 = -1; z1 <= 1; ++z1) {
                    int id = world.func_72798_a(x + x1, y + y1, z + z1);
                    if (Block.field_71973_m[id] == null) continue;
                    Block.field_71973_m[id].beginLeavesDecay(world, x + x1, y + y1, z + z1);
                }
            }
        }
    }

    public int func_71920_b(IBlockAccess iBlockAccess, int x, int y, int z) {
        int metadata = BlockGreenLeaves.unmarkedMetadata(iBlockAccess.func_72805_g(x, y, z));
        if (metadata != BlockType.REDWOOD.metadata()) {
            return this.func_71889_f_(metadata);
        }
        return BlockGreenLeaves.calcSmoothedBiomeFoliageColor(iBlockAccess, x, z);
    }

    public int func_71899_b(int metadata) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingMetadata() : 0;
    }

    private void doSaplingDrop(World world, int x, int y, int z, int metadata, int par7) {
        int idDropped = this.func_71885_a(metadata, world.field_73012_v, par7);
        int damageDropped = this.func_71899_b(metadata);
        this.func_71929_a(world, x, y, z, new ItemStack(idDropped, 1, damageDropped));
    }

    public void func_71914_a(World world, int x, int y, int z, int metadata, float chance, int par7) {
        this.leafTypeDropper((IBlockAccess)world, world, x, y, z, metadata, par7);
    }

    private void leafTypeDropper(IBlockAccess iBlockAccess, World world, int x, int y, int z, int metadata, int par7) {
        int damageValue = BlockGreenLeaves.unmarkedMetadata(iBlockAccess.func_72805_g(x, y, z));
        if (world.field_72995_K) {
            return;
        }
        if (damageValue != BlockType.ACACIA.metadata || !GeneralSettings.bigTreeSaplingDropModifier) {
            if (world.field_73012_v.nextInt(20) == 0) {
                this.doSaplingDrop(world, x, y, z, metadata, par7);
            } else if (world.field_73012_v.nextInt(90) == 0) {
                this.doSaplingDrop(world, x, y, z, metadata, par7);
            }
        }
    }

    public int func_71933_m() {
        return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
    }

    public Icon func_71858_a(int side, int metadata) {
        if ((metadata = BlockGreenLeaves.unmarkedMetadata(metadata)) < 0 || metadata > 2) {
            metadata = 0;
        }
        return this.textures[BlockGreenLeaves.unmarkedMetadata(metadata) * 2 + (!this.func_71926_d() ? 0 : 1)];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71873_h(World world, int x, int y, int z) {
        return BlockGreenLeaves.unmarkedMetadata(world.func_72805_g(x, y, z));
    }

    public int func_71889_f_(int metadata) {
        return (metadata = BlockGreenLeaves.unmarkedMetadata(metadata)) == 0 ? ColorizerFoliage.func_77466_a() : (metadata == 1 ? ColorizerFoliage.func_77468_c() : ColorizerFoliage.func_77470_a((double)0.9f, (double)0.1f));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public void func_71893_a(World world, EntityPlayer player, int x, int y, int z, int md) {
        super.func_71893_a(world, player, x, y, z, md);
    }

    public int func_71885_a(int metadata, Random rand, int par3) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingID() : Block.field_71987_y.field_71990_ca;
    }

    public boolean isLeaves(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_71926_d() {
        return Block.field_71952_K.func_71926_d();
    }

    public boolean isShearable(ItemStack item, World world, int x, int y, int z) {
        return true;
    }

    public void func_71891_b(World world, int x, int y, int z, Entity entity) {
        this.beginLeavesDecay(world, x, y, z);
    }

    public ArrayList onSheared(ItemStack item, World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, BlockGreenLeaves.unmarkedMetadata(world.func_72805_g(x, y, z))));
        return ret;
    }

    public int func_71925_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_72832_d(x, y, z, 0, 0, 2);
    }

    public boolean func_71877_c(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        this.field_72131_c = !Block.field_71952_K.func_71926_d();
        return super.func_71877_c(par1iBlockAccess, par2, par3, par4, par5);
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (BlockGreenLeaves.isUserPlaced(metadata) || !BlockGreenLeaves.isDecaying(metadata)) {
            return;
        }
        int rangeWood = 6;
        int rangeCheckChunk = 7;
        int var9 = 32;
        int var10 = 1024;
        int var11 = 16;
        if (this.adjacentTreeBlocks == null) {
            this.adjacentTreeBlocks = new int[32768];
        }
        if (world.func_72904_c(x - 7, y - 7, z - 7, x + 7, y + 7, z + 7)) {
            int var14;
            int var13;
            int var12;
            for (var12 = -6; var12 <= 6; ++var12) {
                for (var13 = -6; var13 <= 6; ++var13) {
                    for (var14 = -6; var14 <= 6; ++var14) {
                        int id = world.func_72798_a(x + var12, y + var13, z + var14);
                        Block block = Block.field_71973_m[id];
                        this.adjacentTreeBlocks[(var12 + 16) * 1024 + (var13 + 16) * 32 + var14 + 16] = block != null && block.canSustainLeaves(world, x + var12, y + var13, z + var14) ? 0 : (block != null && block.isLeaves(world, x + var12, y + var13, z + var14) ? -2 : -1);
                    }
                }
            }
            for (var12 = 1; var12 <= 4; ++var12) {
                for (var13 = -6; var13 <= 6; ++var13) {
                    for (var14 = -6; var14 <= 6; ++var14) {
                        for (int var15 = -6; var15 <= 6; ++var15) {
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16] != var12 - 1) continue;
                            if (this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] != -2) continue;
                            this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] = var12;
                        }
                    }
                }
            }
        }
        if (this.adjacentTreeBlocks[16912] >= 0) {
            world.func_72921_c(x, y, z, BlockGreenLeaves.clearDecayOnMetadata(metadata), 3);
        } else {
            this.removeLeaves(world, x, y, z);
        }
    }

    public static enum BlockType {
        FIR(0),
        REDWOOD(1),
        ACACIA(2);

        private final int metadata;
        private ItemStack sapling = new ItemStack(Block.field_71987_y);
        private static boolean loadedCustomBlocks;

        static BlockType fromMetadata(int metadata) {
            metadata = BlockGreenLeaves.unmarkedMetadata(metadata);
            for (BlockType type : BlockType.values()) {
                if (type.metadata() != metadata) continue;
                return type;
            }
            return null;
        }

        private static void loadCustomBlocks() {
            if (Element.SAPLING_FIR.isPresent()) {
                BlockType.FIR.sapling = Element.SAPLING_FIR.get();
            }
            if (Element.SAPLING_REDWOOD.isPresent()) {
                BlockType.REDWOOD.sapling = Element.SAPLING_REDWOOD.get();
            }
            if (Element.SAPLING_ACACIA.isPresent()) {
                BlockType.ACACIA.sapling = Element.SAPLING_ACACIA.get();
            }
            loadedCustomBlocks = true;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private BlockType() {
            void metadata;
            this.metadata = metadata;
        }

        int getSaplingID() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.field_77993_c;
        }

        int getSaplingMetadata() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.func_77960_j();
        }

        public int metadata() {
            return this.metadata;
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

