/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.ue;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;

public class TileEntityUniversalElectricityProducer
extends TileEntityEnergyProducer
implements IVoltage,
IConnector {
    public TileEntityUniversalElectricityProducer() {
        this(0);
    }

    public TileEntityUniversalElectricityProducer(int voltageIndex) {
        super(PowerConverterCore.powerSystemUniversalElectricity, voltageIndex, IConductor.class);
    }

    @Override
    public int produceEnergy(int energy) {
        double watts = energy / PowerConverterCore.powerSystemUniversalElectricity.getInternalEnergyPerOutput();
        ElectricityPack powerRemaining = ElectricityNetworkHelper.produceFromMultipleSides((TileEntity)this, (ElectricityPack)new ElectricityPack(watts / this.getVoltage(), this.getVoltage()));
        return MathHelper.func_76128_c((double)(powerRemaining.getWatts() * (double)PowerConverterCore.powerSystemUniversalElectricity.getInternalEnergyPerOutput()));
    }

    public double getVoltage() {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    public boolean canConnect(ForgeDirection direction) {
        return true;
    }
}

