/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.ic2;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;

public class TileEntityIndustrialCraftProducer
extends TileEntityEnergyProducer
implements IEnergySource {
    private boolean _isAddedToEnergyNet;
    private boolean _didFirstAddToNet;
    private int _packetCount;

    public TileEntityIndustrialCraftProducer() {
        this(0);
    }

    public TileEntityIndustrialCraftProducer(int voltageIndex) {
        super(PowerConverterCore.powerSystemIndustrialCraft, voltageIndex, IEnergyAcceptor.class);
        if (voltageIndex == 0) {
            this._packetCount = PowerConverterCore.throttleIC2LVProducer.getInt();
        } else if (voltageIndex == 1) {
            this._packetCount = PowerConverterCore.throttleIC2MVProducer.getInt();
        } else if (voltageIndex == 2) {
            this._packetCount = PowerConverterCore.throttleIC2HVProducer.getInt();
        } else if (voltageIndex == 3) {
            this._packetCount = PowerConverterCore.throttleIC2EVProducer.getInt();
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this._didFirstAddToNet && !this.field_70331_k.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this._didFirstAddToNet = true;
            this._isAddedToEnergyNet = true;
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (!this._isAddedToEnergyNet) {
            this._didFirstAddToNet = false;
        }
    }

    public void func_70313_j() {
        if (this._isAddedToEnergyNet) {
            if (!this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this._isAddedToEnergyNet = false;
        }
        super.func_70313_j();
    }

    @Override
    public int produceEnergy(int energy) {
        if (!this._isAddedToEnergyNet) {
            return energy;
        }
        int eu = energy / PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerOutput();
        for (int i = 0; i < this._packetCount; ++i) {
            int producedEu = Math.min(eu, this.getMaxEnergyOutput());
            EnergyTileSourceEvent e = new EnergyTileSourceEvent((IEnergySource)this, producedEu);
            MinecraftForge.EVENT_BUS.post((Event)e);
            if (e.amount == producedEu || (eu -= producedEu - e.amount) < this.getMaxEnergyOutput()) break;
        }
        return eu * PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerOutput();
    }

    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return true;
    }

    public boolean isAddedToEnergyNet() {
        return this._isAddedToEnergyNet;
    }

    public int getMaxEnergyOutput() {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }
}

