/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.Configuration;

public class PowerSystem {
    private static Map _powerSystems = new HashMap();
    private static Integer _nextPowerSystemId = 0;
    private String _abbreviation;
    private String _name;
    private int _internalEnergyPerInput;
    private int _internalEnergyPerOutput;
    private String[] _voltageNames;
    private int[] _voltageValues;
    private String _unit;
    private int _id;

    public PowerSystem(String name, String abbreviation, int energyPerInput, int energyPerOutput, String[] voltageNames, int[] voltageValues, String unit) {
        this._name = name;
        this._abbreviation = abbreviation;
        this._internalEnergyPerInput = energyPerInput;
        this._internalEnergyPerOutput = energyPerOutput;
        this._voltageNames = voltageNames;
        this._voltageValues = voltageValues;
        this._unit = unit;
    }

    public static void registerPowerSystem(PowerSystem powerSystem) {
        _powerSystems.put(_nextPowerSystemId, powerSystem);
        powerSystem._id = _nextPowerSystemId;
        Integer n = _nextPowerSystemId;
        Integer n2 = _nextPowerSystemId = Integer.valueOf(_nextPowerSystemId + 1);
    }

    public static PowerSystem getPowerSystemById(int id) {
        return (PowerSystem)_powerSystems.get(id);
    }

    public String getAbbreviation() {
        return this._abbreviation;
    }

    public String getName() {
        return this._name;
    }

    public static void loadConfig(Configuration c) {
        String powerRatioComment = "Not all power systems listed here are necessarily used; they may be provided so that\r\nthe ratios are all stored in a single place and for possible future use.";
        c.addCustomCategoryComment("PowerRatios", powerRatioComment);
        for (Map.Entry p : _powerSystems.entrySet()) {
            String configSection = "PowerRatios." + ((PowerSystem)p.getValue())._name;
            ((PowerSystem)p.getValue())._internalEnergyPerInput = c.get(configSection, ((PowerSystem)p.getValue())._name + "InternalEnergyPerEachInput", ((PowerSystem)p.getValue())._internalEnergyPerInput).getInt();
            ((PowerSystem)p.getValue())._internalEnergyPerOutput = c.get(configSection, ((PowerSystem)p.getValue())._name + "InternalEnergyPerEachOutput", ((PowerSystem)p.getValue())._internalEnergyPerOutput).getInt();
        }
    }

    public int getInternalEnergyPerInput() {
        return this._internalEnergyPerInput;
    }

    public int getInternalEnergyPerOutput() {
        return this._internalEnergyPerOutput;
    }

    public String[] getVoltageNames() {
        return this._voltageNames;
    }

    public int[] getVoltageValues() {
        return this._voltageValues;
    }

    public String getUnit() {
        return this._unit;
    }

    public int getId() {
        return this._id;
    }
}

