/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.core.position.INeighboorUpdateTile;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.common.TileEntityCharger;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.gui.PCCreativeTab;
import powercrystals.powerconverters.power.TileEntityBridgeComponent;

public class BlockPowerConverterCommon
extends BlockContainer {
    private Icon _iconBridge;
    private Icon _iconChargerOn;
    private Icon _iconChargerOff;

    public BlockPowerConverterCommon(int i) {
        super(i, Material.field_76267_y);
        this.func_71848_c(1.0f);
        this.func_71864_b("powerconverters.common");
        this.func_71849_a(PCCreativeTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        this._iconBridge = ir.func_94245_a("powercrystals/powerconverters/" + this.func_71917_a() + ".bridge");
        this._iconChargerOn = ir.func_94245_a("powercrystals/powerconverters/" + this.func_71917_a() + ".charger.on");
        this._iconChargerOff = ir.func_94245_a("powercrystals/powerconverters/" + this.func_71917_a() + ".charger.off");
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta == 0) {
            return this._iconBridge;
        }
        if (meta == 2) {
            return this._iconChargerOff;
        }
        return null;
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityBridgeComponent) {
            if (meta == 0) {
                return this._iconBridge;
            }
            if (meta == 2) {
                boolean isConnected = ((TileEntityBridgeComponent)te).isSideConnectedClient(side);
                if (isConnected) {
                    return this._iconChargerOn;
                }
                return this._iconChargerOff;
            }
        }
        return this.func_71858_a(side, meta);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && te instanceof INeighboorUpdateTile) {
            ((INeighboorUpdateTile)te).onNeighboorChanged();
        }
    }

    public TileEntity createTileEntity(World world, int md) {
        if (md == 0) {
            return new TileEntityEnergyBridge();
        }
        if (md == 2) {
            return new TileEntityCharger();
        }
        return this.func_72274_a(world);
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && te instanceof TileEntityBridgeComponent) {
            TileEntityEnergyBridge bridge = ((TileEntityBridgeComponent)te).getFirstBridge();
            if (bridge != null) {
                player.openGui((Object)PowerConverterCore.instance, 0, world, bridge.field_70329_l, bridge.field_70330_m, bridge.field_70327_n);
            }
        } else if (te != null && te instanceof TileEntityEnergyBridge) {
            player.openGui((Object)PowerConverterCore.instance, 0, world, x, y, z);
        }
        return true;
    }

    public int func_71899_b(int i) {
        return i;
    }

    public boolean func_71853_i() {
        return true;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            float shrinkAmount = 0.125f;
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)(y + 1) - shrinkAmount), (double)(z + 1));
        }
        return super.func_71872_e(world, x, y, z);
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityPlayer && world.func_72805_g(x, y, z) == 2) {
            TileEntityCharger charger = (TileEntityCharger)world.func_72796_p(x, y, z);
            charger.setPlayer((EntityPlayer)entity);
        }
    }
}

