/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.world;

import codechicken.core.world.WorldExtension;
import codechicken.core.world.WorldExtensionInstantiator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldExtensionManager {
    private static boolean initialised;
    private static ArrayList extensionIntialisers;
    private static HashMap worldMap;

    static {
        extensionIntialisers = new ArrayList();
        worldMap = new HashMap();
    }

    public static void registerWorldExtension(WorldExtensionInstantiator init) {
        if (!initialised) {
            WorldExtensionManager.init();
        }
        init.instantiatorID = extensionIntialisers.size();
        extensionIntialisers.add(init);
    }

    private static void init() {
        initialised = true;
        MinecraftForge.EVENT_BUS.register((Object)new WorldExtensionEventHandler());
        TickRegistry.registerTickHandler((ITickHandler)new WorldExtensionServerTickHandler(), (Side)Side.SERVER);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            TickRegistry.registerTickHandler((ITickHandler)new WorldExtensionClientTickHandler(), (Side)Side.CLIENT);
        }
    }

    private static void onWorldLoad(aab world) {
        WorldExtension[] extensions = new WorldExtension[extensionIntialisers.size()];
        int i = 0;
        while (i < extensions.length) {
            extensions[i] = ((WorldExtensionInstantiator)extensionIntialisers.get(i)).createWorldExtension(world);
            ++i;
        }
        worldMap.put(world, extensions);
        WorldExtension[] worldExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.load();
            ++n2;
        }
    }

    public static void onWorldUnload(aab world) {
        WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.remove(world);
        int n = worldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.unload();
            ++n2;
        }
    }

    private static void createChunkExtension(aab world, abw chunk) {
        WorldExtension[] extensions = (WorldExtension[])worldMap.get(world);
        int i = 0;
        while (i < extensionIntialisers.size()) {
            if (!extensions[i].containsChunk(chunk)) {
                extensions[i].addChunk(((WorldExtensionInstantiator)extensionIntialisers.get(i)).createChunkExtension(chunk, extensions[i]));
            }
            ++i;
        }
    }

    private static void removeChunk(aab world, abw chunk) {
        WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(world);
        int n = worldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.remChunk(chunk);
            ++n2;
        }
    }

    private static void preTick(aab world) {
        WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(world);
        int n = worldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.preTick();
            ++n2;
        }
    }

    private static void postTick(aab world) {
        WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(world);
        int n = worldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.postTick();
            ++n2;
        }
    }

    public static WorldExtension getWorldExtension(aab world, int instantiatorID) {
        return ((WorldExtension[])worldMap.get(world))[instantiatorID];
    }

    public static class WorldExtensionClientTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.CLIENT)) {
                bds world = Minecraft.x().e;
                if (worldMap.containsKey(world)) {
                    WorldExtensionManager.preTick((aab)world);
                }
            }
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.CLIENT)) {
                bds world = Minecraft.x().e;
                if (worldMap.containsKey(world)) {
                    WorldExtensionManager.postTick((aab)world);
                }
            }
        }

        public EnumSet ticks() {
            return EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "WorldExtenstions";
        }
    }

    public static class WorldExtensionEventHandler {
        @ForgeSubscribe
        public void onChunkDataLoad(ChunkDataEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.loadChunkData(event.getChunk(), event.getData());
                ++n2;
            }
        }

        @ForgeSubscribe
        public void onChunkDataSave(ChunkDataEvent.Save event) {
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.saveChunkData(event.getChunk(), event.getData());
                ++n2;
            }
            if (!event.getChunk().d) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.loadChunk(event.getChunk());
                ++n2;
            }
        }

        @ForgeSubscribe
        public void onChunkUnLoad(ChunkEvent.Unload event) {
            if (event.getChunk() instanceof abv) {
                return;
            }
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.unloadChunk(event.getChunk());
                ++n2;
            }
            if (event.world.I) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onWorldSave(WorldEvent.Save event) {
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.save();
                ++n2;
            }
        }

        @ForgeSubscribe
        public void onWorldLoad(WorldEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
        }

        @ForgeSubscribe
        public void onWorldUnLoad(WorldEvent.Unload event) {
            WorldExtensionManager.onWorldUnload(event.world);
        }

        @ForgeSubscribe
        public void onChunkWatch(ChunkWatchEvent.Watch event) {
            abw chunk = event.player.q.e(event.chunk.a, event.chunk.b);
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.player.q);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.watchChunk(chunk, event.player);
                ++n2;
            }
        }

        @ForgeSubscribe
        public void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
            abw chunk = event.player.q.e(event.chunk.a, event.chunk.b);
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.player.q);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.unwatchChunk(chunk, event.player);
                ++n2;
            }
        }
    }

    public static class WorldExtensionServerTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.WORLD)) {
                WorldExtensionManager.preTick((aab)tickData[0]);
            }
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.WORLD)) {
                WorldExtensionManager.postTick((aab)tickData[0]);
            }
        }

        public EnumSet ticks() {
            return EnumSet.of(TickType.WORLD, TickType.CLIENT);
        }

        public String getLabel() {
            return "WorldExtenstions";
        }
    }
}

