/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ObfuscationMappings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InstructionComparator {
    public static boolean varInsnEqual(VarInsnNode insn1, VarInsnNode insn2) {
        if (insn1.var == -1 || insn2.var == -1) {
            return true;
        }
        return insn1.var == insn2.var;
    }

    public static boolean methodInsnEqual(AbstractInsnNode absnode, int Opcode, ObfuscationMappings.DescriptorMapping method) {
        if (!(absnode instanceof MethodInsnNode) || absnode.getOpcode() != Opcode) {
            return false;
        }
        return method.matches((MethodInsnNode)absnode);
    }

    public static boolean methodInsnEqual(MethodInsnNode insn1, MethodInsnNode insn2) {
        return insn1.owner.equals(insn2.owner) && insn1.name.equals(insn2.name) && insn1.desc.equals(insn2.desc);
    }

    public static boolean fieldInsnEqual(FieldInsnNode insn1, FieldInsnNode insn2) {
        return insn1.owner.equals(insn2.owner) && insn1.name.equals(insn2.name) && insn1.desc.equals(insn2.desc);
    }

    public static boolean ldcInsnEqual(LdcInsnNode insn1, LdcInsnNode insn2) {
        if (insn1.cst.equals("~") || insn2.cst.equals("~")) {
            return true;
        }
        return insn1.cst.equals(insn2.cst);
    }

    public static boolean typeInsnEqual(TypeInsnNode insn1, TypeInsnNode insn2) {
        if (insn1.desc.equals("~") || insn2.desc.equals("~")) {
            return true;
        }
        return insn1.desc.equals(insn2.desc);
    }

    public static boolean iincInsnEqual(IincInsnNode node1, IincInsnNode node2) {
        return node1.var == node2.var && node1.incr == node2.incr;
    }

    public static boolean intInsnEqual(IntInsnNode node1, IntInsnNode node2) {
        if (node1.operand == -1 || node2.operand == -1) {
            return true;
        }
        return node1.operand == node2.operand;
    }

    public static boolean insnEqual(AbstractInsnNode node1, AbstractInsnNode node2) {
        if (node1.getOpcode() != node2.getOpcode()) {
            return false;
        }
        switch (node2.getType()) {
            case 2: {
                return InstructionComparator.varInsnEqual((VarInsnNode)node1, (VarInsnNode)node2);
            }
            case 3: {
                return InstructionComparator.typeInsnEqual((TypeInsnNode)node1, (TypeInsnNode)node2);
            }
            case 4: {
                return InstructionComparator.fieldInsnEqual((FieldInsnNode)node1, (FieldInsnNode)node2);
            }
            case 5: {
                return InstructionComparator.methodInsnEqual((MethodInsnNode)node1, (MethodInsnNode)node2);
            }
            case 9: {
                return InstructionComparator.ldcInsnEqual((LdcInsnNode)node1, (LdcInsnNode)node2);
            }
            case 10: {
                return InstructionComparator.iincInsnEqual((IincInsnNode)node1, (IincInsnNode)node2);
            }
            case 1: {
                return InstructionComparator.intInsnEqual((IntInsnNode)node1, (IntInsnNode)node2);
            }
        }
        return true;
    }

    public static InsnList getImportantList(InsnList list) {
        if (list.size() == 0) {
            return list;
        }
        HashMap<LabelNode, LabelNode> labels = new HashMap<LabelNode, LabelNode>();
        AbstractInsnNode insn = list.getFirst();
        while (insn != null) {
            if (insn instanceof LabelNode) {
                labels.put((LabelNode)insn, (LabelNode)insn);
            }
            insn = insn.getNext();
        }
        InsnList importantNodeList = new InsnList();
        AbstractInsnNode insn2 = list.getFirst();
        while (insn2 != null) {
            if (!(insn2 instanceof LabelNode) && !(insn2 instanceof LineNumberNode)) {
                importantNodeList.add(insn2.clone(labels));
            }
            insn2 = insn2.getNext();
        }
        return importantNodeList;
    }

    public static boolean insnListMatches(InsnList haystack, InsnList needle, int start) {
        if (haystack.size() - start < needle.size()) {
            return false;
        }
        int i = 0;
        while (i < needle.size()) {
            if (!InstructionComparator.insnEqual(haystack.get(i + start), needle.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List insnListFind(InsnList haystack, InsnList needle) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        int start = 0;
        while (start <= haystack.size() - needle.size()) {
            if (InstructionComparator.insnListMatches(haystack, needle, start)) {
                list.add(start);
            }
            ++start;
        }
        return list;
    }

    public static List insnListFindStart(InsnList haystack, InsnList needle) {
        LinkedList<AbstractInsnNode> callNodes = new LinkedList<AbstractInsnNode>();
        Iterator iterator = InstructionComparator.insnListFind(haystack, needle).iterator();
        while (iterator.hasNext()) {
            int callPoint = (Integer)iterator.next();
            callNodes.add(haystack.get(callPoint));
        }
        return callNodes;
    }

    public static List insnListFindEnd(InsnList haystack, InsnList needle) {
        LinkedList<AbstractInsnNode> callNodes = new LinkedList<AbstractInsnNode>();
        Iterator iterator = InstructionComparator.insnListFind(haystack, needle).iterator();
        while (iterator.hasNext()) {
            int callPoint = (Integer)iterator.next();
            callNodes.add(haystack.get(callPoint + needle.size() - 1));
        }
        return callNodes;
    }

    public static List insnListFindL(InsnList haystack, InsnList needle) {
        HashSet<LabelNode> controlFlowLabels = new HashSet<LabelNode>();
        AbstractInsnNode insn = haystack.getFirst();
        while (insn != null) {
            switch (insn.getType()) {
                case 8: 
                case 15: {
                    break;
                }
                case 7: {
                    JumpInsnNode jinsn = (JumpInsnNode)insn;
                    controlFlowLabels.add(jinsn.label);
                    break;
                }
                case 11: {
                    TableSwitchInsnNode tsinsn = (TableSwitchInsnNode)insn;
                    for (LabelNode label : tsinsn.labels) {
                        controlFlowLabels.add(label);
                    }
                    break;
                }
                case 12: {
                    LookupSwitchInsnNode lsinsn = (LookupSwitchInsnNode)insn;
                    for (LabelNode label : lsinsn.labels) {
                        controlFlowLabels.add(label);
                    }
                    break;
                }
            }
            insn = insn.getNext();
        }
        LinkedList<InsnListSection> list = new LinkedList<InsnListSection>();
        int start = 0;
        while (start <= haystack.size() - needle.size()) {
            block13: {
                InsnListSection section = InstructionComparator.insnListMatchesL(haystack, needle, start, controlFlowLabels);
                if (section != null) {
                    for (InsnListSection asection : list) {
                        if (asection.last != section.last) {
                            continue;
                        }
                        break block13;
                    }
                    list.add(section);
                }
            }
            ++start;
        }
        return list;
    }

    private static InsnListSection insnListMatchesL(InsnList haystack, InsnList needle, int start, HashSet controlFlowLabels) {
        int h = start;
        int n = 0;
        while (h < haystack.size() && n < needle.size()) {
            AbstractInsnNode insn = haystack.get(h);
            if (insn.getType() != 15 && (insn.getType() != 8 || controlFlowLabels.contains(insn))) {
                if (!InstructionComparator.insnEqual(haystack.get(h), needle.get(n))) {
                    return null;
                }
                ++n;
            }
            ++h;
        }
        if (n != needle.size()) {
            return null;
        }
        return new InsnListSection(haystack, start, h - 1);
    }

    public static class InsnListSection {
        public AbstractInsnNode first;
        public AbstractInsnNode last;

        public InsnListSection(AbstractInsnNode first, AbstractInsnNode last) {
            this.first = first;
            this.last = last;
        }

        public InsnListSection(InsnList haystack, int start, int end) {
            this(haystack.get(start), haystack.get(end));
        }
    }
}

