/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.electricity.IElectricityNetwork;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public class ElectricityNetworkHelper {
    public static void invalidate(TileEntity tileEntity) {
        for (int i = 0; i < 6; ++i) {
            IElectricityNetwork iElectricityNetwork;
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)i);
            TileEntity tileEntity2 = VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), forgeDirection);
            if (!(tileEntity2 instanceof INetworkProvider) || (iElectricityNetwork = ((INetworkProvider)tileEntity2).getNetwork()) == null) continue;
            iElectricityNetwork.stopRequesting(tileEntity);
            iElectricityNetwork.stopProducing(tileEntity);
        }
    }

    public static EnumSet getDirections(TileEntity tileEntity) {
        EnumSet<ForgeDirection> enumSet = EnumSet.noneOf(ForgeDirection.class);
        if (tileEntity instanceof IConnector) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)i);
                if (!((IConnector)tileEntity).canConnect(forgeDirection)) continue;
                enumSet.add(forgeDirection);
            }
        }
        return enumSet;
    }

    public static ElectricityPack produceFromMultipleSides(TileEntity tileEntity, ElectricityPack electricityPack) {
        return ElectricityNetworkHelper.produceFromMultipleSides(tileEntity, ElectricityNetworkHelper.getDirections(tileEntity), electricityPack);
    }

    public static ElectricityPack produceFromMultipleSides(TileEntity tileEntity, EnumSet enumSet, ElectricityPack electricityPack) {
        List list;
        ElectricityPack electricityPack2 = electricityPack.clone();
        if (tileEntity != null && enumSet != null && (list = ElectricityNetworkHelper.getNetworksFromMultipleSides(tileEntity, enumSet)).size() > 0) {
            double d = electricityPack.getWatts() / (double)list.size();
            double d2 = electricityPack.voltage;
            for (IElectricityNetwork iElectricityNetwork : list) {
                if (d > 0.0 && electricityPack.getWatts() > 0.0) {
                    double d3 = d / d2;
                    iElectricityNetwork.startProducing(tileEntity, d3, d2);
                    electricityPack2.amperes -= d3;
                    continue;
                }
                iElectricityNetwork.stopProducing(tileEntity);
            }
        }
        return electricityPack2;
    }

    public static ElectricityPack consumeFromMultipleSides(TileEntity tileEntity, ElectricityPack electricityPack) {
        return ElectricityNetworkHelper.consumeFromMultipleSides(tileEntity, ElectricityNetworkHelper.getDirections(tileEntity), electricityPack);
    }

    public static ElectricityPack consumeFromMultipleSides(TileEntity tileEntity, EnumSet enumSet, ElectricityPack electricityPack) {
        List list;
        ElectricityPack electricityPack2 = new ElectricityPack();
        if (tileEntity != null && enumSet != null && (list = ElectricityNetworkHelper.getNetworksFromMultipleSides(tileEntity, enumSet)).size() > 0) {
            double d = electricityPack.getWatts() / (double)list.size();
            double d2 = electricityPack.voltage;
            for (IElectricityNetwork iElectricityNetwork : list) {
                if (d > 0.0 && electricityPack.getWatts() > 0.0) {
                    iElectricityNetwork.startRequesting(tileEntity, d / d2, d2);
                    ElectricityPack electricityPack3 = iElectricityNetwork.consumeElectricity(tileEntity);
                    electricityPack2.amperes += electricityPack3.amperes;
                    electricityPack2.voltage = Math.max(electricityPack2.voltage, electricityPack3.voltage);
                    continue;
                }
                iElectricityNetwork.stopRequesting(tileEntity);
            }
        }
        return electricityPack2;
    }

    public static List getNetworksFromMultipleSides(TileEntity tileEntity, EnumSet enumSet) {
        ArrayList<IElectricityNetwork> arrayList = new ArrayList<IElectricityNetwork>();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)i);
            if (!enumSet.contains(forgeDirection)) continue;
            Vector3 vector3 = new Vector3(tileEntity);
            vector3.modifyPositionFromSide(forgeDirection);
            TileEntity tileEntity2 = vector3.getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            IElectricityNetwork iElectricityNetwork = ElectricityNetworkHelper.getNetworkFromTileEntity(tileEntity2, forgeDirection);
            if (iElectricityNetwork == null || arrayList.contains(arrayList)) continue;
            arrayList.add(iElectricityNetwork);
        }
        return arrayList;
    }

    public static IElectricityNetwork getNetworkFromTileEntity(TileEntity tileEntity, ForgeDirection forgeDirection) {
        if (tileEntity != null && tileEntity instanceof INetworkProvider) {
            if (tileEntity instanceof IConnector) {
                if (((IConnector)tileEntity).canConnect(forgeDirection.getOpposite())) {
                    return ((INetworkProvider)tileEntity).getNetwork();
                }
            } else {
                return ((INetworkProvider)tileEntity).getNetwork();
            }
        }
        return null;
    }
}

