/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityRancher
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 2, 2, 1);
    private LiquidTank _tank = new LiquidTank(4000);

    public TileEntityRancher() {
        super(Machine.Rancher);
    }

    @Override
    public String getGuiBackground() {
        return "rancher.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public int getEnergyStoredMax() {
        return 32000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public boolean activateMachine() {
        MFRLiquidMover.pumpLiquid((ILiquidTank)this._tank, this);
        boolean bl = false;
        List list = this.field_70331_k.func_72872_a(EntityLiving.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
        for (Object e : list) {
            IFactoryRanchable iFactoryRanchable;
            List list2;
            if (!(e instanceof EntityLiving)) {
                if (!(e instanceof EntityItem)) continue;
                UtilInventory.dropStack((TileEntity)this, (ItemStack)((EntityItem)e).func_92059_d(), (ForgeDirection)this.getDropDirection());
                continue;
            }
            EntityLiving entityLiving = (EntityLiving)e;
            if (!MFRRegistry.getRanchables().containsKey(entityLiving.getClass()) || (list2 = (iFactoryRanchable = (IFactoryRanchable)MFRRegistry.getRanchables().get(entityLiving.getClass())).ranch(this.field_70331_k, entityLiving, this)) == null) continue;
            for (ItemStack itemStack : list2) {
                if (LiquidContainerRegistry.isLiquid((ItemStack)itemStack)) {
                    this._tank.fill(new LiquidStack(itemStack.field_77993_c, 1000, itemStack.func_77960_j()), true);
                    bl = true;
                    continue;
                }
                UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection)this.getDropDirection());
                bl = true;
            }
            if (!bl) continue;
            this.setIdleTicks(20);
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public String func_70303_b() {
        return "Rancher";
    }

    public int func_70302_i_() {
        return 9;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    @Override
    public boolean canRotate() {
        return true;
    }
}

