/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.TreeHarvestManager;
import powercrystals.minefactoryreloaded.core.TreeHarvestMode;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFruitPicker;
import powercrystals.minefactoryreloaded.gui.container.ContainerFruitPicker;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFruitPicker
extends TileEntityFactoryPowered {
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 1, 0, 0);
    private TreeHarvestManager _treeManager;
    private BlockPosition _lastTree;
    private Random _rand = new Random();

    public TileEntityFruitPicker() {
        super(Machine.FruitPicker);
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public String getGuiBackground() {
        return "fruitpicker.png";
    }

    @Override
    public ContainerFruitPicker getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFruitPicker(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFruitPicker(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public String func_70303_b() {
        return "Fruit Picker";
    }

    @Override
    protected boolean activateMachine() {
        int n = 0;
        int n2 = 0;
        BlockPosition blockPosition = this.getNextTree();
        if (blockPosition == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        n2 = this.field_70331_k.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z);
        IFactoryFruit iFactoryFruit = (IFactoryFruit)MFRRegistry.getFruits().get(new Integer(n));
        List list = iFactoryFruit.getDrops(this.field_70331_k, this._rand, blockPosition.x, blockPosition.y, blockPosition.z);
        ItemStack itemStack = iFactoryFruit.getReplacementBlock(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        iFactoryFruit.prePick(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        if (list != null) {
            for (ItemStack itemStack2 : list) {
                UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack2, (ForgeDirection)this.getDropDirection());
            }
        }
        if (itemStack == null) {
            if (MFRConfig.playSounds.getBoolean(true)) {
                this.field_70331_k.func_72889_a(null, 2001, blockPosition.x, blockPosition.y, blockPosition.z, n + (n2 << 12));
            }
            this.field_70331_k.func_94571_i(blockPosition.x, blockPosition.y, blockPosition.z);
        } else {
            this.field_70331_k.func_72832_d(blockPosition.x, blockPosition.y, blockPosition.z, itemStack.field_77993_c, itemStack.func_77960_j(), 3);
        }
        iFactoryFruit.postPick(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        return true;
    }

    private BlockPosition getNextTree() {
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!MFRRegistry.getFruitLogBlockIds().contains(n)) {
            this._lastTree = null;
            return null;
        }
        BlockPosition blockPosition2 = this.getNextTreeSegment(blockPosition.x, blockPosition.y, blockPosition.z, false);
        if (blockPosition2 != null) {
            this._areaManager.rewindBlock();
        }
        return blockPosition2;
    }

    private BlockPosition getNextTreeSegment(int n, int n2, int n3, boolean bl) {
        if (this._lastTree == null || this._lastTree.x != n || this._lastTree.y != n2 || this._lastTree.z != n3) {
            int n4 = bl ? n2 - MFRConfig.fruitTreeSearchMaxVertical.getInt() : n2;
            int n5 = bl ? n2 : n2 + MFRConfig.fruitTreeSearchMaxVertical.getInt();
            Area area = new Area(n - MFRConfig.fruitTreeSearchMaxHorizontal.getInt(), n + MFRConfig.fruitTreeSearchMaxHorizontal.getInt(), n4, n5, n3 - MFRConfig.fruitTreeSearchMaxHorizontal.getInt(), n3 + MFRConfig.fruitTreeSearchMaxHorizontal.getInt());
            this._treeManager = new TreeHarvestManager(area, bl ? TreeHarvestMode.HarvestInverted : TreeHarvestMode.Harvest);
            this._lastTree = new BlockPosition(n, n2, n3);
        } else if (this._treeManager.getIsDone()) {
            this._treeManager.reset();
        }
        while (!this._treeManager.getIsDone()) {
            BlockPosition blockPosition = this._treeManager.getNextBlock();
            int n6 = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
            if (MFRRegistry.getFruits().containsKey(new Integer(n6)) && ((IFactoryFruit)MFRRegistry.getFruits().get(new Integer(n6))).canBePicked(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z)) {
                return blockPosition;
            }
            this._treeManager.moveNext();
        }
        return null;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean canRotate() {
        return true;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[0]);
    }

    @Override
    public ForgeDirection getDropDirection() {
        return this.getDirectionFacing().getOpposite();
    }
}

