/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiUpgradable;
import powercrystals.minefactoryreloaded.gui.container.ContainerUpgradable;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFertilizer
extends TileEntityFactoryPowered {
    private Random _rand = new Random();
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 1, 0, 0);

    public TileEntityFertilizer() {
        super(Machine.Fertilizer);
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[9]);
    }

    @Override
    public String getGuiBackground() {
        return "fertilizer.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiUpgradable(this.getContainer(inventoryPlayer), (TileEntityFactoryPowered)this);
    }

    @Override
    public ContainerUpgradable getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerUpgradable(this, inventoryPlayer);
    }

    @Override
    public boolean activateMachine() {
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!MFRRegistry.getFertilizables().containsKey(new Integer(n))) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null || !MFRRegistry.getFertilizers().containsKey(new Integer(itemStack.field_77993_c))) continue;
            IFactoryFertilizer iFactoryFertilizer = (IFactoryFertilizer)MFRRegistry.getFertilizers().get(new Integer(itemStack.field_77993_c));
            IFactoryFertilizable iFactoryFertilizable = (IFactoryFertilizable)MFRRegistry.getFertilizables().get(new Integer(n));
            if (iFactoryFertilizer.getFertilizerMeta() != itemStack.func_77960_j() || !iFactoryFertilizable.canFertilizeBlock(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, iFactoryFertilizer.getFertilizerType()) || !iFactoryFertilizable.fertilize(this.field_70331_k, this._rand, blockPosition.x, blockPosition.y, blockPosition.z, iFactoryFertilizer.getFertilizerType())) continue;
            iFactoryFertilizer.consume(itemStack);
            if (itemStack.field_77994_a <= 0) {
                this.func_70299_a(i, null);
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public String func_70303_b() {
        return "Fertilizer";
    }

    public int func_70302_i_() {
        return 10;
    }

    @Override
    public int getEnergyStoredMax() {
        return 32000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 20;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 9;
    }

    @Override
    public boolean canRotate() {
        return true;
    }
}

