/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import powercrystals.minefactoryreloaded.gui.client.GuiDeepStorageUnit;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerDeepStorageUnit;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityDeepStorageUnit
extends TileEntityFactoryInventory
implements IDeepStorageUnit {
    private boolean[] _isSideOutput = new boolean[]{false, false, true, true, true, true};
    private int _storedQuantity;
    private int _storedId;
    private int _storedMeta;
    private boolean _canUpdate = true;

    @Override
    public String getGuiBackground() {
        return "dsu.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiDeepStorageUnit((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerDeepStorageUnit getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerDeepStorageUnit(this, inventoryPlayer);
    }

    public boolean getIsSideOutput(int n) {
        return this._isSideOutput[n];
    }

    public void setSideIsOutput(int n, boolean bl) {
        this._isSideOutput[n] = bl;
    }

    public int getQuantity() {
        return this._storedQuantity;
    }

    public int getQuantityAdjusted() {
        int n = this._storedQuantity;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this._inventory[i] != null && this._storedQuantity == 0) {
                n += this._inventory[i].field_77994_a;
                continue;
            }
            if (this._inventory[i] == null || this._inventory[i].field_77993_c != this._storedId || this._inventory[i].func_77960_j() != this._storedMeta) continue;
            n += this._inventory[i].field_77994_a;
        }
        return n;
    }

    public void setQuantity(int n) {
        this._storedQuantity = n;
    }

    public void clearSlots() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this._inventory[i] = null;
        }
    }

    public int getId() {
        if (this._storedQuantity == 0 && this._inventory[2] != null) {
            return this._inventory[2].field_77993_c;
        }
        return this._storedId;
    }

    public void setId(int n) {
        this._storedId = n;
    }

    public int getMeta() {
        if (this._storedQuantity == 0 && this._inventory[2] != null) {
            return this._inventory[2].func_77960_j();
        }
        return this._storedMeta;
    }

    public void setMeta(int n) {
        this._storedMeta = n;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this._inventory[2] == null && this._storedQuantity > 0) {
            this._inventory[2] = new ItemStack(this._storedId, Math.min(this._storedQuantity, new ItemStack(this._storedId, 1, this._storedMeta).func_77976_d()), this._storedMeta);
            this._storedQuantity -= this._inventory[2].field_77994_a;
        } else if (this._inventory[2] != null && this._inventory[2].field_77994_a < this._inventory[2].func_77976_d() && this._inventory[2].field_77993_c == this._storedId && this._inventory[2].func_77960_j() == this._storedMeta && this._storedQuantity > 0) {
            int n = Math.min(this._inventory[2].func_77976_d() - this._inventory[2].field_77994_a, this._storedQuantity);
            this._inventory[2].field_77994_a += n;
            this._storedQuantity -= n;
        }
        this.checkInput(0);
        this.checkInput(1);
        if (this._inventory[0] == null && this._inventory[1] == null) {
            this._canUpdate = false;
        }
    }

    private void checkInput(int n) {
        if (this._inventory[n] != null) {
            if (this._storedQuantity == 0 && (this._inventory[2] == null || this._inventory[2].field_77993_c == this._inventory[n].field_77993_c && this._inventory[2].func_77960_j() == this._inventory[n].func_77960_j()) && this._inventory[n].func_77978_p() == null) {
                this._storedId = this._inventory[n].field_77993_c;
                this._storedMeta = this._inventory[n].func_77960_j();
                this._storedQuantity = this._inventory[n].field_77994_a;
                this._inventory[n] = null;
            } else if (this._inventory[n].field_77993_c == this._storedId && this._inventory[n].func_77960_j() == this._storedMeta && this._inventory[n].func_77978_p() == null && 2147483581 - this._inventory[n].field_77994_a > this._storedQuantity) {
                this._storedQuantity += this._inventory[n].field_77994_a;
                this._inventory[n] = null;
            } else if (this._inventory[n].field_77993_c != this._storedId || this._inventory[n].func_77960_j() != this._storedMeta || this._inventory[n].func_77978_p() != null) {
                this._inventory[n] = UtilInventory.dropStack((TileEntity)this, (ItemStack)this._inventory[n], (ForgeDirection)this.getDropDirection());
            }
        }
    }

    public int func_70302_i_() {
        return 3;
    }

    public String func_70303_b() {
        return "Deep Storage Unit";
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n) <= 64.0;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        if (forgeDirection.ordinal() > 5) {
            return 0;
        }
        return this._isSideOutput[forgeDirection.ordinal()] ? 2 : 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        if (forgeDirection.ordinal() > 5) {
            return 0;
        }
        return this._isSideOutput[forgeDirection.ordinal()] ? 1 : 2;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (n2 > 5) {
            return false;
        }
        if (!this._isSideOutput[n2]) {
            ItemStack itemStack2 = this.getStoredItemType();
            if (itemStack2 == null && this._inventory[2] != null) {
                itemStack2 = this._inventory[2];
            }
            return !itemStack.func_77942_o() && (itemStack2 == null || itemStack.func_77969_a(itemStack2));
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        if (n2 > 5) {
            return false;
        }
        return this._isSideOutput[n2];
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("storedId", this._storedId);
        nBTTagCompound.func_74768_a("storedMeta", this._storedMeta);
        nBTTagCompound.func_74768_a("storedQuantity", this._storedQuantity);
        nBTTagCompound.func_74757_a("side0output", this._isSideOutput[0]);
        nBTTagCompound.func_74757_a("side1output", this._isSideOutput[1]);
        nBTTagCompound.func_74757_a("side2output", this._isSideOutput[2]);
        nBTTagCompound.func_74757_a("side3output", this._isSideOutput[3]);
        nBTTagCompound.func_74757_a("side4output", this._isSideOutput[4]);
        nBTTagCompound.func_74757_a("side5output", this._isSideOutput[5]);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._storedId = nBTTagCompound.func_74762_e("storedId");
        this._storedMeta = nBTTagCompound.func_74762_e("storedMeta");
        this._storedQuantity = nBTTagCompound.func_74762_e("storedQuantity");
        this._isSideOutput[0] = nBTTagCompound.func_74767_n("side0output");
        this._isSideOutput[1] = nBTTagCompound.func_74767_n("side1output");
        this._isSideOutput[2] = nBTTagCompound.func_74767_n("side2output");
        this._isSideOutput[3] = nBTTagCompound.func_74767_n("side3output");
        this._isSideOutput[4] = nBTTagCompound.func_74767_n("side4output");
        this._isSideOutput[5] = nBTTagCompound.func_74767_n("side5output");
        if (Item.field_77698_e[this._storedId] == null && this._storedQuantity > 0) {
            this._storedQuantity = 0;
        }
    }

    @Override
    public ItemStack getStoredItemType() {
        if (this._storedQuantity > 0 || this._inventory[2] != null) {
            return new ItemStack(this._storedId, this.getQuantityAdjusted(), this._storedMeta);
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int n) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this._inventory[i] == null || this._inventory[i].field_77993_c != this._storedId || this._inventory[i].func_77960_j() != this._storedMeta) continue;
            if (n == 0) {
                this._inventory[i] = null;
                continue;
            }
            if (n >= this._inventory[i].field_77994_a) {
                n -= this._inventory[i].field_77994_a;
                continue;
            }
            if (n >= this._inventory[i].field_77994_a) continue;
            this._inventory[i].field_77994_a = n;
            n = 0;
        }
        this._storedQuantity = n;
        this._canUpdate = true;
    }

    @Override
    public void setStoredItemType(int n, int n2, int n3) {
        this.clearSlots();
        this._storedId = n;
        this._storedMeta = n2;
        this._storedQuantity = n3;
        this._canUpdate = true;
    }

    @Override
    public int getMaxStoredCount() {
        return Integer.MAX_VALUE;
    }

    public boolean canUpdate() {
        return this._canUpdate;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._canUpdate = true;
    }
}

