/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.inventory.InventoryManager;
import powercrystals.core.util.Util;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiBioReactor;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerBioReactor;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityBioReactor
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private LiquidTank _tank = new LiquidTank(4000);
    private int _burnTime;
    private static final int _burnTimeMax = 8000;
    private static final int _bioFuelPerTick = 1;
    private static final int _burnTimeDecreasePerTick = 1;
    private static final int[] _outputValues = new int[]{0, 80, 180, 300, 440, 600, 780, 980, 1200, 1440};

    public int getBurnTime() {
        return this._burnTime;
    }

    public void setBurnTime(int n) {
        this._burnTime = n;
    }

    public int getBurnTimeMax() {
        return 8000;
    }

    public int getOutputValue() {
        int n = 0;
        for (int i = 9; i < 18; ++i) {
            if (this._inventory[i] == null) continue;
            ++n;
        }
        return _outputValues[n];
    }

    public int getOutputValueMax() {
        return _outputValues[9];
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            int n;
            int n2;
            for (n2 = 0; n2 < 9; ++n2) {
                if (this._inventory[n2] == null || !MFRRegistry.getPlantables().containsKey(this._inventory[n2].field_77993_c) || (n = this.findMatchingSlot(this._inventory[n2])) < 0) continue;
                if (this._inventory[n] == null) {
                    this._inventory[n] = this._inventory[n2];
                    this._inventory[n2] = null;
                    continue;
                }
                UtilInventory.mergeStacks((ItemStack)this._inventory[n], (ItemStack)this._inventory[n2]);
                if (this._inventory[n2].field_77994_a > 0) continue;
                this._inventory[n2] = null;
            }
            if (Util.isRedstonePowered((TileEntity)this)) {
                return;
            }
            n2 = this.getOutputValue();
            if (8000 - this._burnTime >= n2) {
                this._burnTime += n2;
                for (n = 9; n < 18; ++n) {
                    if (this._inventory[n] == null) continue;
                    this.func_70298_a(n, 1);
                }
            }
            if (this._burnTime > 0 && (this._tank.getLiquid() == null || this._tank.getLiquid().amount <= this._tank.getCapacity() - 1)) {
                --this._burnTime;
                this._tank.fill(LiquidDictionary.getLiquid((String)"biofuel", (int)1), true);
            }
        }
    }

    private int findMatchingSlot(ItemStack itemStack) {
        for (int i = 9; i < 18; ++i) {
            if (this._inventory[i] == null || this._inventory[i].field_77993_c != itemStack.field_77993_c || this._inventory[i].func_77960_j() != itemStack.func_77960_j()) continue;
            return i;
        }
        return this.findEmptySlot();
    }

    private int findEmptySlot() {
        for (int i = 9; i < 18; ++i) {
            if (this._inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getGuiBackground() {
        return "bioreactor.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiBioReactor(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerBioReactor getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerBioReactor(this, inventoryPlayer);
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    public int func_70302_i_() {
        return 18;
    }

    public String func_70303_b() {
        return "Bio Reactor";
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 9;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("burnTime", this._burnTime);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._burnTime = nBTTagCompound.func_74762_e("burnTime");
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (i == n || this._inventory[i] == null || !InventoryManager.stacksEqual((ItemStack)this._inventory[i], (ItemStack)itemStack)) continue;
            return false;
        }
        return true;
    }
}

