/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoSpawner;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoSpawner;
import powercrystals.minefactoryreloaded.item.ItemSafariNet;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoSpawner
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private static final int _spawnRange = 4;
    private LiquidTank _tank = new LiquidTank(4000);
    private boolean _spawnExact = false;

    public TileEntityAutoSpawner() {
        super(Machine.AutoSpawner);
    }

    public boolean getSpawnExact() {
        return this._spawnExact;
    }

    public void setSpawnExact(boolean bl) {
        this._spawnExact = bl;
    }

    @Override
    public String getGuiBackground() {
        return "autospawner.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoSpawner(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerAutoSpawner getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoSpawner(this, inventoryPlayer);
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public String func_70303_b() {
        return "Auto-Spawner";
    }

    @Override
    protected boolean activateMachine() {
        if (this._inventory[0] == null || !(this._inventory[0].func_77973_b() instanceof ItemSafariNet) || this._inventory[0].func_77978_p() == null || ItemSafariNet.isSingleUse(this._inventory[0]) || MFRRegistry.getAutoSpawnerBlacklist().contains(this._inventory[0].func_77978_p().func_74779_i("id"))) {
            this.setWorkDone(0);
            return false;
        }
        if (this.getWorkDone() < this.getWorkMax()) {
            if (this._tank.getLiquid() != null && this._tank.getLiquid().amount >= 10) {
                this._tank.getLiquid().amount -= 10;
                this.setWorkDone(this.getWorkDone() + 1);
                return true;
            }
            return false;
        }
        Entity entity = EntityList.func_75620_a((String)this._inventory[0].func_77978_p().func_74779_i("id"), (World)this.field_70331_k);
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityLiving = (EntityLiving)entity;
        entityLiving.func_82163_bD();
        if (this._spawnExact) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)this._inventory[0].func_77978_p().func_74737_b();
            if (nBTTagCompound.func_74767_n("SkeletonType") && nBTTagCompound.func_74764_b("Equipment")) {
                for (int i = 1; i < nBTTagCompound.func_74761_m("Equipment").func_74745_c(); ++i) {
                    nBTTagCompound.func_74761_m("Equipment").func_74744_a(1);
                    nBTTagCompound.func_74761_m("Equipment").func_74742_a((NBTBase)new NBTTagCompound());
                }
            } else {
                nBTTagCompound.func_82580_o("Equipment");
            }
            entityLiving.func_70037_a(nBTTagCompound);
        }
        double d = (double)this.field_70329_l + (this.field_70331_k.field_73012_v.nextDouble() - this.field_70331_k.field_73012_v.nextDouble()) * 4.0;
        double d2 = this.field_70330_m + this.field_70331_k.field_73012_v.nextInt(3) - 1;
        double d3 = (double)this.field_70327_n + (this.field_70331_k.field_73012_v.nextDouble() - this.field_70331_k.field_73012_v.nextDouble()) * 4.0;
        entityLiving.func_70012_b(d, d2, d3, this.field_70331_k.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!this.field_70331_k.func_72855_b(entityLiving.field_70121_D) || !this.field_70331_k.func_72945_a((Entity)entityLiving, entityLiving.field_70121_D).isEmpty() || this.field_70331_k.func_72953_d(entityLiving.field_70121_D) && !(entityLiving instanceof EntityWaterMob) || !this.field_70331_k.func_72953_d(entityLiving.field_70121_D) && entityLiving instanceof EntityWaterMob) {
            return false;
        }
        this.field_70331_k.func_72838_d((Entity)entityLiving);
        this.field_70331_k.func_72926_e(2004, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
        entityLiving.func_70656_aK();
        this.setWorkDone(0);
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 32000;
    }

    @Override
    public int getWorkMax() {
        return this._spawnExact ? MFRConfig.autospawnerCostExact.getInt() : MFRConfig.autospawnerCostStandard.getInt();
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        if (liquidStack == null || liquidStack.itemID != LiquidDictionary.getLiquid((String)"mobEssence", (int)1000).itemID) {
            return 0;
        }
        return this._tank.fill(liquidStack, bl);
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return this.fill(ForgeDirection.UNKNOWN, liquidStack, bl);
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return !ItemSafariNet.isSingleUse(itemStack) && !ItemSafariNet.isEmpty(itemStack);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._spawnExact = nBTTagCompound.func_74767_n("spawnExact");
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("spawnExact", this._spawnExact);
    }
}

