/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.minefactoryreloaded.core.AutoEnchantmentHelper;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoEnchanter;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoEnchanter;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoEnchanter
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private Random _rand = new Random();
    private int _targetLevel = 30;
    private LiquidTank _tank = new LiquidTank(4000);

    public TileEntityAutoEnchanter() {
        super(Machine.AutoEnchanter);
    }

    @Override
    public String getGuiBackground() {
        return "autoenchanter.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoEnchanter(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerAutoEnchanter getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoEnchanter(this, inventoryPlayer);
    }

    @Override
    public int getWorkMax() {
        if (this.func_70301_a(0) != null && this.func_70301_a((int)0).field_77993_c == Item.field_77729_bt.field_77779_bT) {
            return 250;
        }
        return this._targetLevel + (int)(Math.pow((double)this._targetLevel / 7.5, 4.0) * 10.0 * this.getEnchantmentMultiplier());
    }

    private double getEnchantmentMultiplier() {
        ItemStack itemStack = this.func_70301_a(0);
        if (itemStack == null) {
            return 1.0;
        }
        Map map = AutoEnchantmentHelper.func_82781_a((ItemStack)itemStack);
        if (map == null || map.size() == 0) {
            return 1.0;
        }
        return Math.pow((double)map.size() + 1.0, 2.0);
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    public int getTargetLevel() {
        return this._targetLevel;
    }

    public void setTargetLevel(int n) {
        this._targetLevel = n;
        if (this._targetLevel > 30) {
            this._targetLevel = 30;
        }
        if (this._targetLevel < 1) {
            this._targetLevel = 1;
        }
        if (this.getWorkDone() >= this.getWorkMax()) {
            this.activateMachine();
        }
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean activateMachine() {
        ItemStack itemStack = this.func_70301_a(0);
        if (itemStack == null) {
            this.setWorkDone(0);
            return false;
        }
        if (itemStack.func_77973_b().func_77619_b() == 0 && itemStack.field_77993_c != Item.field_77729_bt.field_77779_bT || itemStack.field_77993_c == Item.field_92105_bW.field_77779_bT) {
            this.func_70299_a(0, null);
            this.func_70299_a(1, itemStack);
            this.setWorkDone(0);
            return true;
        }
        if (this.getWorkDone() >= this.getWorkMax()) {
            if (itemStack.field_77993_c == Item.field_77729_bt.field_77779_bT) {
                this.func_70299_a(0, null);
                this.func_70299_a(1, new ItemStack(Item.field_77809_bD));
            } else {
                AutoEnchantmentHelper.addRandomEnchantment(this._rand, itemStack, this._targetLevel);
                this.func_70299_a(0, null);
                this.func_70299_a(1, itemStack);
                this.setWorkDone(0);
            }
            return true;
        }
        if (this._tank.getLiquid() != null && this._tank.getLiquid().amount >= 4) {
            this._tank.drain(4, true);
            this.setWorkDone(this.getWorkDone() + 1);
            return true;
        }
        return false;
    }

    @Override
    public String func_70303_b() {
        return "Enchanter";
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public int func_70297_j_() {
        return MFRConfig.enableCompatibleAutoEnchanter.getBoolean(false) ? 64 : 1;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 2;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("targetLevel", this._targetLevel);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._targetLevel = nBTTagCompound.func_74762_e("targetLevel");
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        if (liquidStack == null || liquidStack.itemID != LiquidDictionary.getCanonicalLiquid((String)"mobEssence").itemID) {
            return 0;
        }
        return this._tank.fill(liquidStack, bl);
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return this.fill(ForgeDirection.UNKNOWN, liquidStack, bl);
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        if (liquidStack != null && liquidStack.itemID == LiquidDictionary.getCanonicalLiquid((String)"mobEssence").itemID) {
            return this._tank;
        }
        return null;
    }
}

