/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public abstract class TileEntityLiquidFabricator
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private int _liquidId;
    private int _liquidFabPerTick;
    private LiquidTank _tank;

    protected TileEntityLiquidFabricator(int n, int n2, Machine machine) {
        super(machine.getActivationEnergyMJ() * n2);
        this._liquidId = n;
        this._liquidFabPerTick = n2;
        this._tank = new LiquidTank(1000);
    }

    @Override
    protected boolean activateMachine() {
        if (this._liquidId < 0) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        if (this._tank.getLiquid() != null && this._tank.getCapacity() - this._tank.getLiquid().amount < this._liquidFabPerTick) {
            return false;
        }
        this._tank.fill(new LiquidStack(this._liquidId, this._liquidFabPerTick), true);
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 0;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    public int func_70302_i_() {
        return 0;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }
}

