/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.block.BlockFactoryMachine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoAnvil;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoBrewer;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoDisenchanter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoEnchanter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoJukebox;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityAutoSpawner;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBioFuelGenerator;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBioReactor;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBlockBreaker;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBlockSmasher;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityBreeder;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityChronotyper;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityCollector;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityComposter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityDeepStorageUnit;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityEjector;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityEnchantmentRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityFertilizer;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityFisher;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityFruitPicker;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityGrinder;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityHarvester;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityItemRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrillPrecharger;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLavaFabricator;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLiquiCrafter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLiquidRouter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityMeatPacker;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityOilFabricator;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityPlanter;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityRancher;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityRedNote;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySewer;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySlaughterhouse;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySludgeBoiler;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityUnifier;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityVet;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityWeather;

public class Machine {
    public static Machine Planter = new Machine(0, 0, "Planter", TileEntityPlanter.class, "factoryPlanter", 16);
    public static Machine Fisher = new Machine(0, 1, "Fisher", TileEntityFisher.class, "factoryFisher", 2);
    public static Machine Harvester = new Machine(0, 2, "Harvester", TileEntityHarvester.class, "factoryHarvester", 24);
    public static Machine Rancher = new Machine(0, 3, "Rancher", TileEntityRancher.class, "factoryRancher", 32);
    public static Machine Fertilizer = new Machine(0, 4, "Fertilizer", TileEntityFertilizer.class, "factoryFertilizer", 96);
    public static Machine Vet = new Machine(0, 5, "Vet", TileEntityVet.class, "factoryVet", 32);
    public static Machine ItemCollector = new Machine(0, 6, "ItemCollector", TileEntityCollector.class, "factoryItemCollector", 0);
    public static Machine BlockBreaker = new Machine(0, 7, "BlockBreaker", TileEntityBlockBreaker.class, "factoryBlockBreaker", 96);
    public static Machine WeatherCollector = new Machine(0, 8, "WeatherCollector", TileEntityWeather.class, "factoryWeather", 4);
    public static Machine SludgeBoiler = new Machine(0, 9, "SludgeBoiler", TileEntitySludgeBoiler.class, "factorySludgeBoiler", 2);
    public static Machine Sewer = new Machine(0, 10, "Sewer", TileEntitySewer.class, "factorySewer", 0);
    public static Machine Composter = new Machine(0, 11, "Composter", TileEntityComposter.class, "factoryComposter", 2);
    public static Machine Breeder = new Machine(0, 12, "Breeder", TileEntityBreeder.class, "factoryBreeder", 64);
    public static Machine Grinder = new Machine(0, 13, "Grinder", TileEntityGrinder.class, "factoryGrinder", 320);
    public static Machine AutoEnchanter = new Machine(0, 14, "AutoEnchanter", TileEntityAutoEnchanter.class, "factoryEnchanter", 16);
    public static Machine Chronotyper = new Machine(0, 15, "Chronotyper", TileEntityChronotyper.class, "factoryChronotyper", 128);
    public static Machine Ejector = new Machine(1, 0, "Ejector", TileEntityEjector.class, "factoryEjector", 0);
    public static Machine ItemRouter = new Machine(1, 1, "ItemRouter", TileEntityItemRouter.class, "factoryItemRouter", 0);
    public static Machine LiquidRouter = new Machine(1, 2, "LiquidRouter", TileEntityLiquidRouter.class, "factoryLiquidRouter", 0);
    public static Machine DeepStorageUnit = new Machine(1, 3, "DeepStorageUnit", TileEntityDeepStorageUnit.class, "factoryDeepStorageUnit", 0);
    public static Machine LiquiCrafter = new Machine(1, 4, "LiquiCrafter", TileEntityLiquiCrafter.class, "factoryLiquiCrafter", 0);
    public static Machine LavaFabricator = new Machine(1, 5, "LavaFabricator", TileEntityLavaFabricator.class, "factoryLavaFabricator", 20);
    public static Machine OilFabricator = new Machine(1, 6, "OilFabricator", TileEntityOilFabricator.class, "factoryOilFabricator", 588);
    public static Machine AutoJukebox = new Machine(1, 7, "AutoJukebox", TileEntityAutoJukebox.class, "factoryAutoJukebox", 0);
    public static Machine Unifier = new Machine(1, 8, "Unifier", TileEntityUnifier.class, "factoryUnifier", 0);
    public static Machine AutoSpawner = new Machine(1, 9, "AutoSpawner", TileEntityAutoSpawner.class, "factoryAutoSpawner", 60);
    public static Machine BioReactor = new Machine(1, 10, "BioReactor", TileEntityBioReactor.class, "factoryBioReactor", 0);
    public static Machine BioFuelGenerator = new Machine(1, 11, "BioFuelGenerator", TileEntityBioFuelGenerator.class, "factoryBioFuelGenerator", 16);
    public static Machine AutoDisenchanter = new Machine(1, 12, "AutoDisenchanter", TileEntityAutoDisenchanter.class, "factoryDisenchanter", 32);
    public static Machine Slaughterhouse = new Machine(1, 13, "Slaughterhouse", TileEntitySlaughterhouse.class, "factorySlaughterhouse", 100);
    public static Machine MeatPacker = new Machine(1, 14, "MeatPacker", TileEntityMeatPacker.class, "factoryMeatPacker", 2);
    public static Machine EnchantmentRouter = new Machine(1, 15, "EnchantmentRouter", TileEntityEnchantmentRouter.class, "factoryEnchantmentRouter", 0);
    public static Machine LaserDrill = new Machine(2, 0, "LaserDrill", TileEntityLaserDrill.class, "factoryLaserDrill", 0);
    public static Machine LaserDrillPrecharger = new Machine(2, 1, "LaserDrillPrecharger", TileEntityLaserDrillPrecharger.class, "factoryLaserDrillPrecharger", 500);
    public static Machine AutoAnvil = new Machine(2, 2, "AutoAnvil", TileEntityAutoAnvil.class, "factoryAnvil", 16);
    public static Machine BlockSmasher = new Machine(2, 3, "BlockSmasher", TileEntityBlockSmasher.class, "factoryBlockSmasher", 1);
    public static Machine RedNote = new Machine(2, 4, "RedNote", TileEntityRedNote.class, "factoryRedNote", 0);
    public static Machine AutoBrewer = new Machine(2, 5, "AutoBrewer", TileEntityAutoBrewer.class, "factoryAutoBrewer", 4);
    public static Machine FruitPicker = new Machine(2, 6, "FruitPicker", TileEntityFruitPicker.class, "factoryFruitPicker", 32);
    private static List _machines;
    private static Map _machineMappingss;
    private static Map _highestMetas;
    private int _blockIndex;
    private int _meta;
    private String _name;
    private String _internalName;
    private Class _tileEntityClass;
    private String _tileEntityName;
    private Icon[] _iconsActive = new Icon[6];
    private Icon[] _iconsIdle = new Icon[6];
    private int _activationEnergyMJ;
    private Property _isRecipeEnabled;

    private Machine(int n, int n2, String string, Class clazz, String string2, int n3) {
        this._blockIndex = n;
        this._meta = n2;
        this._name = string;
        this._internalName = "tile.mfr.machine." + string.toLowerCase();
        this._tileEntityClass = clazz;
        this._tileEntityName = string2;
        this._activationEnergyMJ = n3;
        if (_machines == null) {
            _machines = new LinkedList();
        }
        if (_machineMappingss == null) {
            _machineMappingss = new HashMap();
        }
        if (_highestMetas == null) {
            _highestMetas = new HashMap();
        }
        _machineMappingss.put(this._meta | this._blockIndex << 4, this);
        _machines.add(this);
        if (_highestMetas.get(this._blockIndex) == null || (Integer)_highestMetas.get(this._blockIndex) < this._meta) {
            _highestMetas.put(this._blockIndex, this._meta);
        }
    }

    public static Machine getMachineFromIndex(int n, int n2) {
        return (Machine)_machineMappingss.get(n2 | n << 4);
    }

    public static Machine getMachineFromId(int n, int n2) {
        return (Machine)_machineMappingss.get(n2 | ((BlockFactoryMachine)Block.field_71973_m[n]).getBlockIndex() << 4);
    }

    public static int getHighestMetadata(int n) {
        return (Integer)_highestMetas.get(n);
    }

    public static List values() {
        return _machines;
    }

    public static void LoadTextures(int n, IconRegister iconRegister) {
        for (Machine machine : _machines) {
            if (machine.getBlockIndex() != n) continue;
            machine.loadIcons(iconRegister);
        }
    }

    public String getInternalName() {
        return this._internalName;
    }

    public int getBlockId() {
        return ((Block)MineFactoryReloadedCore.machineBlocks.get((Object)Integer.valueOf((int)this._blockIndex))).field_71990_ca;
    }

    public int getMeta() {
        return this._meta;
    }

    public int getBlockIndex() {
        return this._blockIndex;
    }

    public boolean getIsRecipeEnabled() {
        return this._isRecipeEnabled.getBoolean(true);
    }

    public TileEntityFactory getNewTileEntity() {
        try {
            TileEntityFactory tileEntityFactory = (TileEntityFactory)((Object)this._tileEntityClass.newInstance());
            return tileEntityFactory;
        }
        catch (IllegalAccessException illegalAccessException) {
            FMLLog.severe((String)"Unable to create instance of TileEntity from %s", (Object[])new Object[]{this._tileEntityClass.getName()});
            return null;
        }
        catch (InstantiationException instantiationException) {
            FMLLog.severe((String)"Unable to create instance of TileEntity from %s", (Object[])new Object[]{this._tileEntityClass.getName()});
            return null;
        }
    }

    public int getActivationEnergyMJ() {
        return this._activationEnergyMJ;
    }

    public void load(Configuration configuration) {
        this._isRecipeEnabled = configuration.get("Machine", this._name + ".Recipe.Enabled", true);
        if (this._activationEnergyMJ > 0) {
            this._activationEnergyMJ = configuration.get("Machine", this._name + ".ActivationCostMJ", this._activationEnergyMJ).getInt();
        }
        MinecraftForge.setBlockHarvestLevel((Block)((Block)MineFactoryReloadedCore.machineBlocks.get(this._blockIndex)), (int)this._meta, (String)"pickaxe", (int)0);
        GameRegistry.registerTileEntity((Class)this._tileEntityClass, (String)this._tileEntityName);
    }

    public void loadIcons(IconRegister iconRegister) {
        this._iconsActive[0] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".active.bottom");
        this._iconsActive[1] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".active.top");
        this._iconsActive[2] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".active.front");
        this._iconsActive[3] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".active.back");
        this._iconsActive[4] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".active.left");
        this._iconsActive[5] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".active.right");
        this._iconsIdle[0] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".idle.bottom");
        this._iconsIdle[1] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".idle.top");
        this._iconsIdle[2] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".idle.front");
        this._iconsIdle[3] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".idle.back");
        this._iconsIdle[4] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".idle.left");
        this._iconsIdle[5] = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.getInternalName() + ".idle.right");
    }

    public Icon getIcon(int n, boolean bl) {
        if (bl) {
            return this._iconsActive[n];
        }
        return this._iconsIdle[n];
    }
}

