/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.forestry;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizerStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;

@Mod(modid="MineFactoryReloaded|CompatForestry", name="MFR Compat: Forestry", version="1.5.1R2.6.4", dependencies="after:MineFactoryReloaded;after:Forestry")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Forestry {
    @Mod.Init
    public static void load(FMLInitializationEvent fMLInitializationEvent) {
        if (!Loader.isModLoaded((String)"Forestry")) {
            FMLLog.warning((String)"Forestry missing - MFR Forestry Compat not loading", (Object[])new Object[0]);
            return;
        }
        try {
            Item item;
            Class<?> clazz = Class.forName("forestry.core.config.ForestryItem");
            if (clazz != null) {
                item = (Item)clazz.getField("fertilizerCompound").get(null);
                Item item2 = (Item)clazz.getField("peat").get(null);
                MFRRegistry.registerFertilizer(new FertilizerStandard(item.field_77779_bT, 0));
                MFRRegistry.registerSludgeDrop(5, new ItemStack(item2));
            }
            if ((item = Class.forName("forestry.core.config.ForestryBlock")) != null) {
                MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)item.getField((String)"log1").get(null)).field_71990_ca, HarvestType.Tree));
                MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)item.getField((String)"log2").get(null)).field_71990_ca, HarvestType.Tree));
                MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)item.getField((String)"log3").get(null)).field_71990_ca, HarvestType.Tree));
                MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)item.getField((String)"log4").get(null)).field_71990_ca, HarvestType.Tree));
                MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)item.getField((String)"log5").get(null)).field_71990_ca, HarvestType.Tree));
                MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)item.getField((String)"log6").get(null)).field_71990_ca, HarvestType.Tree));
                MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)item.getField((String)"log7").get(null)).field_71990_ca, HarvestType.Tree));
                MFRRegistry.registerHarvestable(new HarvestableTreeLeaves(((Block)item.getField((String)"leaves").get(null)).field_71990_ca));
                MFRRegistry.registerPlantable(new PlantableStandard(((Block)item.getField((String)"saplingGE").get(null)).field_71990_ca, ((Block)item.getField((String)"saplingGE").get(null)).field_71990_ca));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Mod.PostInit
    public static void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        if (!Loader.isModLoaded((String)"Forestry")) {
            return;
        }
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getOrCreateLiquid((String)"milk", (LiquidStack)new LiquidStack((Block)MineFactoryReloadedCore.milkLiquid, 1000)), new ItemStack(Item.field_77771_aG), new ItemStack(Item.field_77788_aw)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getOrCreateLiquid((String)"sludge", (LiquidStack)new LiquidStack((Block)MineFactoryReloadedCore.sludgeLiquid, 1000)), new ItemStack(MineFactoryReloadedCore.sludgeBucketItem), new ItemStack(Item.field_77788_aw)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getOrCreateLiquid((String)"sewage", (LiquidStack)new LiquidStack((Block)MineFactoryReloadedCore.sewageLiquid, 1000)), new ItemStack(MineFactoryReloadedCore.sewageBucketItem), new ItemStack(Item.field_77788_aw)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getOrCreateLiquid((String)"mobEssence", (LiquidStack)new LiquidStack((Block)MineFactoryReloadedCore.essenceLiquid, 1000)), new ItemStack(MineFactoryReloadedCore.mobEssenceBucketItem), new ItemStack(Item.field_77788_aw)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getOrCreateLiquid((String)"biofuel", (LiquidStack)new LiquidStack((Block)MineFactoryReloadedCore.biofuelLiquid, 1000)), new ItemStack(MineFactoryReloadedCore.bioFuelBucketItem), new ItemStack(Item.field_77788_aw)));
        MineFactoryReloadedCore.proxy.onPostTextureStitch(null);
    }
}

