/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;

public abstract class MFRLiquidMover {
    public static boolean manuallyFillTank(ITankContainerBucketable iTankContainerBucketable, EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        LiquidStack liquidStack = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemStack);
        if (liquidStack != null && iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, liquidStack, false) == liquidStack.amount) {
            iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, liquidStack, true);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, UtilInventory.consumeItem((ItemStack)itemStack));
            }
            return true;
        }
        return false;
    }

    public static boolean manuallyDrainTank(ITankContainerBucketable iTankContainerBucketable, EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        if (LiquidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
            for (ILiquidTank iLiquidTank : iTankContainerBucketable.getTanks(ForgeDirection.UNKNOWN)) {
                LiquidStack liquidStack = iLiquidTank.getLiquid();
                ItemStack itemStack2 = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)liquidStack, (ItemStack)itemStack);
                if (!LiquidContainerRegistry.isFilledContainer((ItemStack)itemStack2)) continue;
                LiquidStack liquidStack2 = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemStack2);
                if (entityPlayer.field_71075_bZ.field_75098_d) {
                    iLiquidTank.drain(liquidStack2.amount, true);
                    return true;
                }
                if (itemStack.field_77994_a == 1) {
                    iLiquidTank.drain(liquidStack2.amount, true);
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, itemStack2);
                    return true;
                }
                if (!entityPlayer.field_71071_by.func_70441_a(itemStack2)) continue;
                iLiquidTank.drain(liquidStack2.amount, true);
                --itemStack.field_77994_a;
                return true;
            }
        }
        return false;
    }

    public static void pumpLiquid(ILiquidTank iLiquidTank, TileEntityFactory tileEntityFactory) {
        if (iLiquidTank != null && iLiquidTank.getLiquid() != null && iLiquidTank.getLiquid().amount > 0) {
            LiquidStack liquidStack = iLiquidTank.getLiquid().copy();
            liquidStack.amount = Math.min(liquidStack.amount, 1000);
            for (BlockPosition blockPosition : new BlockPosition((TileEntity)tileEntityFactory).getAdjacent(true)) {
                TileEntity tileEntity = tileEntityFactory.field_70331_k.func_72796_p(blockPosition.x, blockPosition.y, blockPosition.z);
                if (tileEntity == null || !(tileEntity instanceof ITankContainer)) continue;
                int n = ((ITankContainer)tileEntity).fill(blockPosition.orientation.getOpposite(), liquidStack, true);
                iLiquidTank.drain(n, true);
                liquidStack.amount -= n;
                if (liquidStack.amount > 0) continue;
                break;
            }
        }
    }
}

