/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetHistorian;

public class BlockRedNetPanel
extends BlockContainer
implements IConnectableRedNet {
    private int[] _blankOutputs = new int[16];

    public BlockRedNetPanel(int n) {
        super(n, Material.field_76267_y);
        this.func_71864_b("mfr.rednet.panel");
        this.func_71848_c(0.8f);
        this.func_71849_a(MFRCreativeTab.tab);
    }

    public void func_71902_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            if (((TileEntityFactory)tileEntity).getDirectionFacing() == ForgeDirection.NORTH) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
            } else if (((TileEntityFactory)tileEntity).getDirectionFacing() == ForgeDirection.SOUTH) {
                this.func_71905_a(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
            } else if (((TileEntityFactory)tileEntity).getDirectionFacing() == ForgeDirection.EAST) {
                this.func_71905_a(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else if (((TileEntityFactory)tileEntity).getDirectionFacing() == ForgeDirection.WEST) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
            }
        }
    }

    public void func_71860_a(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        if (entityLiving == null) {
            return;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (itemStack.func_77978_p() != null) {
            itemStack.func_77978_p().func_74768_a("x", n);
            itemStack.func_77978_p().func_74768_a("y", n2);
            itemStack.func_77978_p().func_74768_a("z", n3);
            tileEntity.func_70307_a(itemStack.func_77978_p());
        }
        if (tileEntity instanceof TileEntityFactory && ((TileEntityFactory)tileEntity).canRotate()) {
            int n4 = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (n4 == 0) {
                ((TileEntityFactory)tileEntity).rotateDirectlyTo(3);
            } else if (n4 == 1) {
                ((TileEntityFactory)tileEntity).rotateDirectlyTo(4);
            } else if (n4 == 2) {
                ((TileEntityFactory)tileEntity).rotateDirectlyTo(2);
            } else if (n4 == 3) {
                ((TileEntityFactory)tileEntity).rotateDirectlyTo(5);
            }
        }
    }

    public boolean func_71903_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, n, n2, n3, n4);
        if (MinecraftForge.EVENT_BUS.post((Event)playerInteractEvent) || playerInteractEvent.getResult() == Event.Result.DENY || playerInteractEvent.useBlock == Event.Result.DENY) {
            return false;
        }
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (MFRUtil.isHoldingHammer(entityPlayer) && tileEntity instanceof TileEntityFactory && ((TileEntityFactory)tileEntity).canRotate()) {
            ((TileEntityFactory)tileEntity).rotate();
            world.func_72845_h(n, n2, n3);
            return true;
        }
        if (tileEntity instanceof TileEntityFactory && ((TileEntityFactory)tileEntity).getContainer(entityPlayer.field_71071_by) != null) {
            entityPlayer.openGui((Object)MineFactoryReloadedCore.instance(), 0, world, n, n2, n3);
            return true;
        }
        if (tileEntity instanceof TileEntityRedNetHistorian && itemStack != null && itemStack.field_77993_c == Item.field_77756_aW.field_77779_bT) {
            ((TileEntityRedNetHistorian)tileEntity).setSelectedSubnet(15 - itemStack.func_77960_j());
            world.func_72845_h(n, n2, n3);
            return true;
        }
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return MineFactoryReloadedCore.renderIdRedNetPanel;
    }

    public boolean isBlockSolidOnSide(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int n) {
        return new TileEntityRedNetHistorian();
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            return forgeDirection == ((TileEntityFactory)tileEntity).getDirectionFacing() ? RedNetConnectionType.CableAll : RedNetConnectionType.None;
        }
        return RedNetConnectionType.None;
    }

    @Override
    public int[] getOutputValues(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return this._blankOutputs;
    }

    @Override
    public int getOutputValue(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        return 0;
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetHistorian) {
            ((TileEntityRedNetHistorian)tileEntity).valuesChanged(nArray);
        }
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("powercrystals/minefactoryreloaded/" + this.func_71917_a());
    }
}

