/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.crops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public abstract class CropCard {
    @SideOnly(value=Side.CLIENT)
    protected Icon[] textures;

    public abstract String name();

    public String discoveredBy() {
        return "Alblaka";
    }

    public String desc(int n) {
        String[] stringArray = this.attributes();
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        if (n == 0) {
            String string = stringArray[0];
            if (stringArray.length >= 2) {
                string = string + ", " + stringArray[1];
                if (stringArray.length >= 3) {
                    string = string + ",";
                }
            }
            return string;
        }
        if (stringArray.length < 3) {
            return "";
        }
        String string = stringArray[2];
        if (stringArray.length >= 4) {
            string = string + ", " + stringArray[3];
        }
        return string;
    }

    public abstract int tier();

    public abstract int stat(int var1);

    public abstract String[] attributes();

    public abstract int maxSize();

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IconRegister iconRegister) {
        this.textures = new Icon[this.maxSize()];
        for (int i = 1; i <= this.textures.length; ++i) {
            this.textures[i - 1] = iconRegister.func_94245_a("ic2:crop/blockCrop." + this.name() + "." + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getSprite(ICropTile iCropTile) {
        if (iCropTile.getSize() <= 0 || iCropTile.getSize() > this.textures.length) {
            return null;
        }
        return this.textures[iCropTile.getSize() - 1];
    }

    public String getTextureFile() {
        return "/ic2/sprites/crops_0.png";
    }

    public int growthDuration(ICropTile iCropTile) {
        return this.tier() * 200;
    }

    public abstract boolean canGrow(ICropTile var1);

    public int weightInfluences(ICropTile iCropTile, float f, float f2, float f3) {
        return (int)(f + f2 + f3);
    }

    public boolean canCross(ICropTile iCropTile) {
        return iCropTile.getSize() >= 3;
    }

    public boolean rightclick(ICropTile iCropTile, EntityPlayer entityPlayer) {
        return iCropTile.harvest(true);
    }

    public abstract boolean canBeHarvested(ICropTile var1);

    public float dropGainChance() {
        float f = 1.0f;
        for (int i = 0; i < this.tier(); ++i) {
            f = (float)((double)f * 0.95);
        }
        return f;
    }

    public abstract ItemStack getGain(ICropTile var1);

    public byte getSizeAfterHarvest(ICropTile iCropTile) {
        return 1;
    }

    public boolean leftclick(ICropTile iCropTile, EntityPlayer entityPlayer) {
        return iCropTile.pick(true);
    }

    public float dropSeedChance(ICropTile iCropTile) {
        if (iCropTile.getSize() == 1) {
            return 0.0f;
        }
        float f = 0.5f;
        if (iCropTile.getSize() == 2) {
            f /= 2.0f;
        }
        for (int i = 0; i < this.tier(); ++i) {
            f = (float)((double)f * 0.8);
        }
        return f;
    }

    public ItemStack getSeeds(ICropTile iCropTile) {
        return iCropTile.generateSeeds(iCropTile.getID(), iCropTile.getGrowth(), iCropTile.getGain(), iCropTile.getResistance(), iCropTile.getScanLevel());
    }

    public void onNeighbourChange(ICropTile iCropTile) {
    }

    public int emitRedstone(ICropTile iCropTile) {
        return 0;
    }

    public void onBlockDestroyed(ICropTile iCropTile) {
    }

    public int getEmittedLight(ICropTile iCropTile) {
        return 0;
    }

    public boolean onEntityCollision(ICropTile iCropTile, Entity entity) {
        if (entity instanceof EntityLiving) {
            return ((EntityLiving)entity).func_70051_ag();
        }
        return false;
    }

    public void tick(ICropTile iCropTile) {
    }

    public boolean isWeed(ICropTile iCropTile) {
        return iCropTile.getSize() >= 2 && (iCropTile.getID() == 0 || iCropTile.getGrowth() >= 24);
    }

    public final int getId() {
        return Crops.instance.getIdFor(this);
    }
}

