/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.railcraft;

import java.lang.reflect.Method;
import java.util.List;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.IFuelContextHelper;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.TooltipCache;
import mods.neiplugins.common.Utils;
import mods.neiplugins.railcraft.RailcraftFuelHelper;
import mods.railcraft.api.fuel.FuelManager;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class BoilerFuelContextHelper
implements IFuelContextHelper {
    protected Class solid;
    protected Class liquid;
    protected boolean enabled;
    protected Method getFuelPerConversion;
    protected Method getNumTanks;
    protected Method getTicksPerConversion;

    public BoilerFuelContextHelper(Class solid, Class liquid) {
        this.solid = solid;
        this.liquid = liquid;
        this.enabled = true;
        try {
            Class cls = Utils.findClass("mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox");
            this.getFuelPerConversion = Utils.findMethod(cls, "getFuelPerConversion", Integer.TYPE);
            cls = Utils.findClass("mods.railcraft.common.blocks.machine.beta.TileBoiler");
            this.getNumTanks = Utils.findMethod(cls, "getNumTanks", new Class[0]);
            this.getTicksPerConversion = Utils.findMethod(cls, "getTicksPerConversion", new Class[0]);
            this.enabled = this.getFuelPerConversion != null && this.getNumTanks != null && this.getTicksPerConversion != null;
        }
        catch (Exception ex) {
            NEIPlugins.logInfo("Error in BoilerFuelContextHelper: {0}", ex.getMessage());
            this.enabled = false;
        }
    }

    @Override
    public String getName() {
        return "Steam Boiler";
    }

    @Override
    public String getKey() {
        return "railcraft.boiler";
    }

    @Override
    public List getDescription() {
        return null;
    }

    @Override
    public boolean displayFuelTooltip(GuiContainer gui) {
        return false;
    }

    @Override
    public boolean haveContextTooltip(GuiContainer gui) {
        return this.solid == gui.getClass() || this.liquid == gui.getClass();
    }

    protected float getFuelConsumption(GuiContainer gui) {
        try {
            Object tile = Utils.getField(gui.getClass(), "tile", gui);
            if (tile == null) {
                return 0.0f;
            }
            Integer numTanks = (Integer)this.getNumTanks.invoke(tile, new Object[0]);
            if (numTanks == 0) {
                return 0.0f;
            }
            Integer burnCycle = (Integer)this.getTicksPerConversion.invoke(tile, new Object[0]);
            if (burnCycle == 0) {
                return 0.0f;
            }
            return ((Float)this.getFuelPerConversion.invoke(tile, numTanks)).floatValue() * (float)numTanks.intValue() / (float)burnCycle.intValue();
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    public int getFuelValueSolid(ItemStack item) {
        return RailcraftFuelHelper.getFuelValue(item);
    }

    public int getFuelValueLiquid(ItemStack item) {
        LiquidStack liquid = LiquidHelper.getLiquidStack(item);
        if (liquid != null) {
            return FuelManager.getBoilerFuelValue((LiquidStack)liquid);
        }
        return 0;
    }

    @Override
    public List getContextTooltip(GuiContainer gui, ItemStack stack, List currenttip) {
        TooltipCache cache;
        float consumption;
        String hKey = "";
        int boilerFuelValue = 0;
        if (gui.getClass() == this.solid) {
            hKey = "railcraft.solidfirebox";
            boilerFuelValue = this.getFuelValueSolid(stack);
        } else if (gui.getClass() == this.liquid) {
            hKey = "railcraft.liquidfirebox";
            boilerFuelValue = this.getFuelValueLiquid(stack);
        } else {
            return currenttip;
        }
        if (this.enabled && boilerFuelValue > 0 && (consumption = this.getFuelConsumption(gui)) > 0.0f) {
            currenttip.add("\u00a7eCurrent burning time: " + Math.round(Math.ceil((float)boilerFuelValue / consumption)) + " ticks");
        }
        if ((cache = FuelTooltip.getContextCache(gui)).addCachedTooltip(stack, currenttip)) {
            return currenttip;
        }
        FuelTooltip.addContextTooltipCached(gui, currenttip, stack, hKey);
        return currenttip;
    }
}

