/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineCentrifuge;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.neiplugins.common.PositionedStackWithTooltip;
import mods.neiplugins.common.Utils;
import mods.neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class CentrifugeRecipeHandler
extends ForestryRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};

    @Override
    public String getRecipeId() {
        return "forestry.centrifuge";
    }

    public String getRecipeName() {
        return "Centrifuge";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(49, 8, 20, 52), this.getRecipeId(), new Object[0]));
    }

    public ArrayList getRecipes() {
        MachineCentrifuge.RecipeManager cfr_ignored_0 = (MachineCentrifuge.RecipeManager)RecipeManagers.centrifugeManager;
        return MachineCentrifuge.RecipeManager.recipes;
    }

    public boolean canProduce(MachineCentrifuge.Recipe recipe, ItemStack result) {
        for (ItemStack stack : recipe.products.keySet()) {
            if (!Utils.areStacksSameTypeCrafting(stack, result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineCentrifuge.Recipe irecipe : this.getRecipes()) {
            if (irecipe.products.size() <= 0) continue;
            this.arecipes.add(new CachedCentrifugeRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MachineCentrifuge.Recipe irecipe : this.getRecipes()) {
            if (!this.canProduce(irecipe, result)) continue;
            this.arecipes.add(new CachedCentrifugeRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (MachineCentrifuge.Recipe irecipe : this.getRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.resource, (ItemStack)ingredient) || irecipe.products.size() <= 0) continue;
            CachedCentrifugeRecipe recipe = new CachedCentrifugeRecipe(irecipe);
            recipe.setIngredientPermutation(recipe.resources, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 57, 25, 176, 0, 4, 17, ((CachedCentrifugeRecipe)((Object)this.arecipes.get((int)recipe))).timePerItem * 5, 3);
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/centrifuge.png";
    }

    public class CachedCentrifugeRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList products;
        ArrayList resources;
        HashMap iproducts;
        int timePerItem;

        public CachedCentrifugeRecipe(MachineCentrifuge.Recipe recipe) {
            super((TemplateRecipeHandler)CentrifugeRecipeHandler.this);
            this.resources = new ArrayList();
            this.resources.add(new PositionedStack((Object)recipe.resource, 29, 26));
            this.timePerItem = recipe.timePerItem;
            this.setProducts(recipe.products);
        }

        public void setProducts(HashMap iproducts) {
            this.iproducts = iproducts;
            this.products = new ArrayList();
            int i = 0;
            for (Map.Entry product : iproducts.entrySet()) {
                if (i > 8) break;
                PositionedStackWithTooltip stack = new PositionedStackWithTooltip(((ItemStack)product.getKey()).func_77946_l(), 93 + stackorder[i][0] * 18, 8 + stackorder[i][1] * 18);
                stack.setIntegerChanceTooltip((Integer)product.getValue());
                this.products.add(stack);
                ++i;
            }
        }

        public ArrayList getOtherStacks() {
            ArrayList stacks = new ArrayList();
            for (int i = 1; i < this.products.size(); ++i) {
                stacks.add(this.products.get(i));
            }
            return stacks;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(CentrifugeRecipeHandler.this.cycleticks / 20, this.resources);
        }

        public PositionedStack getResult() {
            return (PositionedStack)this.products.get(0);
        }
    }
}

