/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class BiogasFuelHandler
extends ForestryRecipeHandler {
    static Rectangle fuelTank = new Rectangle(84, 8, 16, 58);
    static Rectangle heatingTank = new Rectangle(102, 8, 16, 58);
    static Rectangle currentFuelTank = new Rectangle(25, 36, 16, 16);
    static Point overlayTank = new Point(176, 0);

    @Override
    public String getRecipeId() {
        return "forestry.biogas.fuel";
    }

    public String getRecipeName() {
        return "Biogas Engine Fuel";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(28, 22, 12, 8), "forestry.biogas.fuel", new Object[0]));
    }

    @Override
    public void loadUsageRecipes(LiquidStack ingredient) {
        EngineBronzeFuel fuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(ingredient.itemID);
        if (fuel != null) {
            this.arecipes.add(new CachedBiogasFuel(fuel));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        if (t != null) {
            this.loadUsageRecipes(t);
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (EngineBronzeFuel fuel : FuelManager.bronzeEngineFuel.values()) {
            this.arecipes.add(new CachedBiogasFuel(fuel));
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/bioengine.png";
    }

    public class BiogasFuelLiquidTank
    extends LiquidTank {
        public EngineBronzeFuel fuel;

        public BiogasFuelLiquidTank(EngineBronzeFuel fuel, int capacity, Rectangle position) {
            super(new LiquidStack(fuel.liquid.field_77993_c, 10000, fuel.liquid.func_77960_j()), capacity, position);
            this.liquid.amount = capacity;
            this.fuel = fuel;
        }

        @Override
        public List additionalHandleTooltip(List currenttip) {
            if (this.liquid.itemID > 0) {
                currenttip.add("\u00a77Stats per bucket:");
                currenttip.add("\u00a77Output: " + this.fuel.powerPerCycle + " MJ/t");
                currenttip.add("\u00a77Duration: " + this.fuel.burnDuration + " t");
                if (this.fuel.dissipationMultiplier > 2) {
                    currenttip.add("\u00a7cConstantly consume lava");
                }
            }
            return currenttip;
        }
    }

    public class CachedBiogasFuel
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ArrayList slot_input;
        LiquidTank fueltank;
        LiquidTank heatingtank;
        LiquidTank currentfueltank;

        public CachedBiogasFuel(EngineBronzeFuel fuel) {
            super((TemplateRecipeHandler)BiogasFuelHandler.this);
            this.fueltank = new LiquidTank(new LiquidStack(fuel.liquid.field_77993_c, 10000, fuel.liquid.func_77960_j()), 10000, fuelTank, overlayTank);
            this.heatingtank = new LiquidTank(new LiquidStack(Block.field_71938_D.field_71990_ca, 10000), 10000, heatingTank, overlayTank);
            this.currentfueltank = new BiogasFuelLiquidTank(fuel, 1000, currentFuelTank);
            this.fueltank.showAmount = false;
            this.heatingtank.showAmount = false;
            this.currentfueltank.showAmount = false;
            this.currentfueltank.showCapacity = false;
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.currentfueltank.liquid, 138, 11, 138, 29);
            this.slot_input = new ArrayList();
            if (input_cont[1] != null) {
                this.slot_input.add(input_cont[1]);
            }
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(BiogasFuelHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.fueltank);
            res.add(this.heatingtank);
            res.add(this.currentfueltank);
            return res;
        }
    }
}

