/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.IPositionedStackWithTooltipHandler;
import mods.neiplugins.common.LiquidTank;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public abstract class LiquidTemplateRecipeHandler
extends TemplateRecipeHandler {
    public abstract String getRecipeId();

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public void loadCraftingRecipes(LiquidStack result) {
    }

    public void loadUsageRecipes(LiquidStack ingredient) {
    }

    public void loadSameRecipeId() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        try {
            if (outputId.equals(this.getRecipeId())) {
                this.loadSameRecipeId();
            } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof LiquidStack) {
                this.loadCraftingRecipes((LiquidStack)results[0]);
            } else {
                super.loadCraftingRecipes(outputId, results);
            }
        }
        catch (Exception ex) {
            NEIPlugins.logWarning("Error occured while calling LiquidTemplateRecipeHandler.loadCraftingRecipes for recipeId: {0}", ex, this.getRecipeId());
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        try {
            if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
                this.loadUsageRecipes((LiquidStack)ingredients[0]);
            } else {
                super.loadUsageRecipes(inputId, ingredients);
            }
        }
        catch (Exception ex) {
            NEIPlugins.logWarning("Error occured while calling LiquidTemplateRecipeHandler.loadUsageRecipes for recipeId: {0}", ex, this.getRecipeId());
        }
    }

    public void drawForeground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        gui.bindTexture(this.getGuiTexture());
        this.drawExtras(gui, recipe);
        this.drawLiquidTanks(gui, recipe);
    }

    public void drawLiquidTanks(GuiContainerManager gui, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                tank.draw(gui, this.getGuiTexture());
            }
        }
    }

    protected boolean transferLiquidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.field_74198_m - offset.x, mousepos.y - guiRecipe.field_74197_n - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse) || tank.liquid.itemID <= 0 || !(usage ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}))) continue;
                return true;
            }
        }
        return false;
    }

    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        currenttip = super.handleTooltip(guiRecipe, currenttip, recipe);
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (guiRecipe.manager.shouldShowTooltip() && crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.field_74198_m - offset.x, mousepos.y - guiRecipe.field_74197_n - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public Rectangle getRectangleFromPositionedStack(PositionedStack stack) {
        return new Rectangle(stack.relx - 1, stack.rely - 1, 18, 18);
    }

    public List handleItemTooltip(GuiRecipe gui, ItemStack itemStack, List currenttip, int recipe) {
        TemplateRecipeHandler.CachedRecipe irecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        Point mousepos = gui.manager.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(mousepos.x - gui.field_74198_m - offset.x, mousepos.y - gui.field_74197_n - offset.y);
        for (PositionedStack stack : irecipe.getIngredients()) {
            if (!(stack instanceof IPositionedStackWithTooltipHandler) || !this.getRectangleFromPositionedStack(stack).contains(relMouse)) continue;
            currenttip = ((IPositionedStackWithTooltipHandler)stack).handleTooltip(gui, currenttip);
        }
        for (PositionedStack stack : irecipe.getOtherStacks()) {
            if (!(stack instanceof IPositionedStackWithTooltipHandler) || !this.getRectangleFromPositionedStack(stack).contains(relMouse)) continue;
            currenttip = ((IPositionedStackWithTooltipHandler)stack).handleTooltip(gui, currenttip);
        }
        PositionedStack stack = irecipe.getResult();
        if (stack instanceof IPositionedStackWithTooltipHandler && this.getRectangleFromPositionedStack(stack).contains(relMouse)) {
            currenttip = ((IPositionedStackWithTooltipHandler)stack).handleTooltip(gui, currenttip);
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"recipe") ? this.transferLiquidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"usage") && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferLiquidTank(gui, recipe, false) : button == 1 && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }
}

