/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.FuelTooltipHandler;
import mods.neiplugins.common.IFuelContextHelper;
import mods.neiplugins.common.IFuelHelper;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.TooltipCache;
import mods.neiplugins.common.Utils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public abstract class FuelTooltip {
    public static DecimalFormat heatFormat = new DecimalFormat("0.#");
    public static DecimalFormat MJtFormat = new DecimalFormat("0.0");
    public static final String linePrefix = "\u00a77";
    public static Map registredHelpers = new HashMap();
    public static Map contextHelpers = new HashMap();
    public static List helpersPosition = new ArrayList();
    public static Set disabledHelpers = new HashSet();
    public static Set disabledContextHelpers = new HashSet();
    public static Set allowedNBTItems = new HashSet();
    protected static boolean showContextTooltip;
    protected static boolean showLiquiqAsItemFuelTooltip;
    protected static boolean showLiquidContainerFuelTooltip;
    protected static boolean showItemStackFuelTooltip;
    protected static Class lastGuiContainer;
    protected static TooltipCache lastContextCache;

    public static void addFuelHelper(boolean hide, IFuelHelper helper) {
        String key = helper.getKey();
        if (!registredHelpers.containsKey(key)) {
            registredHelpers.put(key, helper);
        }
        if (!helpersPosition.contains(key)) {
            helpersPosition.add(key);
        }
        if (hide) {
            disabledHelpers.add(key);
        }
    }

    public static void addFuelHelper(IFuelHelper helper) {
        FuelTooltip.addFuelHelper(false, helper);
    }

    public static void addContextFuelHelper(IFuelContextHelper helper) {
        String key = helper.getKey();
        if (!contextHelpers.containsKey(key)) {
            contextHelpers.put(key, helper);
        }
    }

    public static void addValidNBTItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        int key = Utils.itemStackToInt(stack);
        if (key != 0) {
            allowedNBTItems.add(key);
        }
    }

    public static boolean isValidFuelItem(ItemStack stack) {
        return stack != null && (!stack.func_77942_o() || allowedNBTItems.contains(Utils.itemStackToInt(stack)));
    }

    public static void addLiquidStackFuelTooltip(List currenttip, LiquidStack liquid, Set disabledHelpers) {
        if (liquid == null) {
            return;
        }
        for (String key : helpersPosition) {
            if (disabledHelpers.contains(key)) continue;
            currenttip = ((IFuelHelper)registredHelpers.get(key)).getLiquidStackFuelTooltip(liquid, currenttip);
        }
    }

    public static void addItemStackFuelTooltip(List currenttip, ItemStack stack, Set disabledHelpers) {
        if (stack == null) {
            return;
        }
        for (String key : helpersPosition) {
            if (disabledHelpers.contains(key)) continue;
            currenttip = ((IFuelHelper)registredHelpers.get(key)).getItemStackFuelTooltip(stack, currenttip);
        }
    }

    public static void addCommonFuelTooltip(List currenttip, ItemStack stack, Set disabledHelpers) {
        if (stack == null) {
            return;
        }
        for (String key : helpersPosition) {
            if (disabledHelpers.contains(key)) continue;
            try {
                if (showItemStackFuelTooltip) {
                    currenttip = ((IFuelHelper)registredHelpers.get(key)).getItemStackFuelTooltip(stack, currenttip);
                }
                LiquidStack liquid = null;
                if (showLiquidContainerFuelTooltip) {
                    liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)stack);
                }
                if (showLiquiqAsItemFuelTooltip && liquid == null && !LiquidHelper.isLiquid(liquid = new LiquidStack(stack.field_77993_c, 1000, stack.func_77960_j()))) {
                    liquid = null;
                }
                if (liquid == null) continue;
                currenttip = ((IFuelHelper)registredHelpers.get(key)).getLiquidStackFuelTooltip(liquid, currenttip);
            }
            catch (Exception ex) {
                NEIPlugins.logWarningEx("Error occurred while calling FuelTooltip.addCommonFuelTooltip for fuel helper {0} and item {1}", ex, key, stack);
                currenttip.add("\u00a7c<Error occured>");
            }
        }
    }

    public static void addHighlightFuelTooltip(List currenttip, ItemStack stack, Set disabledHelpers, String hKey) {
        if (stack == null) {
            return;
        }
        for (String key : helpersPosition) {
            try {
                if (key.equals(hKey)) {
                    List templist = new ArrayList();
                    templist = ((IFuelHelper)registredHelpers.get(key)).getItemStackFuelTooltip(stack, templist);
                    LiquidStack liquid = LiquidHelper.getLiquidStack(stack);
                    if (liquid != null) {
                        templist = ((IFuelHelper)registredHelpers.get(key)).getLiquidStackFuelTooltip(liquid, templist);
                    }
                    for (String line : templist) {
                        if (line.startsWith(linePrefix)) {
                            currenttip.add("\u00a7e" + line.substring(2));
                            continue;
                        }
                        currenttip.add(line);
                    }
                    continue;
                }
                if (disabledHelpers.contains(key)) continue;
                if (showItemStackFuelTooltip) {
                    currenttip = ((IFuelHelper)registredHelpers.get(key)).getItemStackFuelTooltip(stack, currenttip);
                }
                LiquidStack liquid = null;
                if (showLiquidContainerFuelTooltip) {
                    liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)stack);
                }
                if (showLiquiqAsItemFuelTooltip && liquid == null && !LiquidHelper.isLiquid(liquid = new LiquidStack(stack.field_77993_c, 1000, stack.func_77960_j()))) {
                    liquid = null;
                }
                if (liquid == null) continue;
                currenttip = ((IFuelHelper)registredHelpers.get(key)).getLiquidStackFuelTooltip(liquid, currenttip);
            }
            catch (Exception ex) {
                NEIPlugins.logWarningEx("Error occurred while calling FuelTooltip.addHighlightFuelTooltip for fuel helper {0} and item {1}", ex, key, stack);
                currenttip.add("\u00a7c<Error occured>");
            }
        }
    }

    public static TooltipCache getContextCache(GuiContainer gui) {
        if (lastGuiContainer != gui.getClass()) {
            lastContextCache.clear();
            lastGuiContainer = gui.getClass();
        }
        return lastContextCache;
    }

    public static void addContextTooltipCached(GuiContainer gui, List currenttip, ItemStack stack, String hKey) {
        FuelTooltip.addContextTooltipCached(gui, currenttip, stack, disabledHelpers, hKey);
    }

    public static void addContextTooltipCached(GuiContainer gui, List currenttip, ItemStack stack, Set disabledHelpers, String hKey) {
        TooltipCache tooltipCache = FuelTooltip.getContextCache(gui);
        if (tooltipCache.addCachedTooltip(stack, currenttip) || !FuelTooltip.isValidFuelItem(stack)) {
            return;
        }
        ArrayList<String> fueltooltip = new ArrayList<String>();
        FuelTooltip.addHighlightFuelTooltip(fueltooltip, stack, disabledHelpers, hKey);
        if (fueltooltip.size() > 0) {
            fueltooltip.add(0, "\u00a77Can produce:");
            currenttip.addAll(fueltooltip);
        }
        if (!stack.func_77942_o()) {
            if (fueltooltip.size() > 0) {
                tooltipCache.put(stack, fueltooltip);
            } else {
                tooltipCache.put(stack, null);
            }
        }
    }

    public static void updateSettings() {
        showContextTooltip = Utils.getBooleanSetting("mistaqur.showContextTooltip");
        showLiquidContainerFuelTooltip = Utils.getBooleanSetting("mistaqur.showLiquidContainerFuelTooltip");
        showLiquiqAsItemFuelTooltip = Utils.getBooleanSetting("mistaqur.showLiquiqAsItemFuelTooltip");
        showItemStackFuelTooltip = Utils.getBooleanSetting("mistaqur.showItemStackFuelTooltip");
        FuelTooltipHandler.tooltipCache.clear();
    }

    public static String compactValueF(float value) {
        if (value > 99.0f) {
            return heatFormat.format((float)Math.round(value / 100.0f) / 10.0f) + "k";
        }
        return Integer.toString(Math.round(value));
    }

    public static String compactValue(int value) {
        if (value > 99 && value % 100 == 0) {
            return heatFormat.format((float)value / 1000.0f) + "k";
        }
        return Integer.toString(value);
    }

    public static String convertHeatValue(int value, int second) {
        return FuelTooltip.compactValue(value) + " heat";
    }

    public static String convertMJt(int value) {
        return MJtFormat.format(value);
    }

    public static String convertMJtF(float value) {
        return MJtFormat.format(value);
    }

    static {
        lastGuiContainer = null;
        lastContextCache = new TooltipCache();
    }
}

