/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.RecipeHandlerUtils;
import mods.neiplugins.common.Registry;
import mods.neiplugins.common.Utils;
import mods.neiplugins.lists.SimpleListElement;
import mods.neiplugins.mfr.GuiLaserDrillList;
import mods.neiplugins.mfr.MFRFuelHelper;
import mods.neiplugins.mfr.SludgeRecipeHandler;

public class NEIPlugins_MFR
implements IPlugin {
    public static final String PLUGIN_NAME = "MineFactoryReloaded";
    public static final String PLUGIN_VERSION = "1.0.3";
    public static final String REQUIRED_MOD = "MineFactoryReloaded";
    private boolean sludgeActive;
    private boolean laserDrillActive;

    @Override
    public String getPluginName() {
        return "MineFactoryReloaded";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        if (!NEIPlugins.getMod().hasMod("MineFactoryReloaded")) {
            return false;
        }
        Class MFRRegistry = Utils.findClass("powercrystals.minefactoryreloaded.MFRRegistry");
        if (Utils.findClass("powercrystals.core.random.WeightedRandomItemStack") == null || MFRRegistry == null) {
            NEIPlugins.logInfo("Failed to find necessary classes for mod \"{0}\"", "MineFactoryReloaded");
            return false;
        }
        this.sludgeActive = Utils.findMethod(MFRRegistry, "getSludgeDrops", new Class[0]) != null;
        this.laserDrillActive = Utils.findMethod(MFRRegistry, "getLaserOres", new Class[0]) != null;
        return true;
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        if (this.sludgeActive && SludgeRecipeHandler.loadLiquid()) {
            RecipeHandlerUtils.addToRecipeList("MineFactory Reloaded", "Sludge Boiler", 0, "mfr.sludge", new Object[0]);
            API.registerUsageHandler((IUsageHandler)new SludgeRecipeHandler());
            API.registerRecipeHandler((ICraftingHandler)new SludgeRecipeHandler());
        } else {
            NEIPlugins.logInfo("Sludge Boiler recipe handler is disabled", new Object[0]);
        }
        if (this.laserDrillActive) {
            Registry.infoListMenu.add(new SimpleListElement("MFR Laser Drill Drops"){

                @Override
                public boolean click(int button) {
                    return button == 0 ? GuiLaserDrillList.showList(this.title) : false;
                }
            });
        } else {
            NEIPlugins.logInfo("Laser Drill info list is disabled", new Object[0]);
        }
        Class cls = Utils.findClass("powercrystals.minefactoryreloaded.tile.machine.TileEntityBioFuelGenerator");
        MFRFuelHelper.bfgEnergyProducedPerConsumption = Utils.getFieldInt(cls, "energyProducedPerConsumption", null);
        if (MFRFuelHelper.bfgEnergyProducedPerConsumption > 0) {
            MFRFuelHelper.bfgLiquidConsumedPerTick = Utils.getFieldInt(cls, "liquidConsumedPerTick", null);
            MFRFuelHelper.bfgTicksBetweenConsumption = Utils.getFieldInt(cls, "ticksBetweenConsumption", null);
            if (MFRFuelHelper.bfgLiquidConsumedPerTick > 0) {
                MFRFuelHelper.registerFuelHelpers();
            }
        }
    }
}

