/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.logging.Level;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.buildcraft.AssemblyRecipeHandler;
import mods.neiplugins.buildcraft.BuildcraftFuelHelper;
import mods.neiplugins.buildcraft.IronEngineFuelsHandler;
import mods.neiplugins.buildcraft.RefineryRecipeHandler;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.ItemApiHelper;
import mods.neiplugins.common.RecipeHandlerUtils;
import mods.neiplugins.common.Utils;
import net.minecraft.item.ItemStack;

public class NEIPlugins_Buildcraft
implements IPlugin {
    public static final String PLUGIN_NAME = "BuildCraft";
    public static final String PLUGIN_VERSION = "1.5.0";
    public static final String REQUIRED_MOD = "BuildCraft|Core";
    public static final String REQUIRED_MOD1 = "BuildCraft|Builders";
    public static final String REQUIRED_MOD2 = "BuildCraft|Energy";
    public static final String REQUIRED_MOD3 = "BuildCraft|Factory";
    public static final String REQUIRED_MOD4 = "BuildCraft|Silicon";
    public static final String REQUIRED_MOD5 = "BuildCraft|Transport";
    public static boolean buildersLoaded;
    public static boolean energyLoaded;
    public static boolean factoryLoaded;
    public static boolean siliconLoaded;
    public static boolean transportLoaded;
    private static ItemStack assemblyTable;
    private static ItemStack refineryBlock;

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod(REQUIRED_MOD);
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        buildersLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD1);
        energyLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD2);
        factoryLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD3);
        siliconLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD4);
        transportLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD5);
        this.configureItemPanel();
        this.addHandlers();
    }

    private void addHandlers() {
        if (energyLoaded) {
            API.registerRecipeHandler((ICraftingHandler)new IronEngineFuelsHandler());
            API.registerUsageHandler((IUsageHandler)new IronEngineFuelsHandler());
            BuildcraftFuelHelper.guiCombustionEngine = Utils.findClass("buildcraft.energy.gui.GuiCombustionEngine");
            BuildcraftFuelHelper.guiSteamEngine = Utils.findClass("buildcraft.energy.gui.GuiSteamEngine");
        } else {
            NEIPlugins.log(Level.INFO, "Mod Buildcraft|Energy not found", new Object[0]);
        }
        if (buildersLoaded) {
            API.registerRecipeHandler((ICraftingHandler)new RefineryRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new RefineryRecipeHandler());
            RecipeHandlerUtils.addToRecipeList("Buildcraft", refineryBlock, "Refinery", 0, "buildcraft.refinery", new Object[0]);
        }
        if (siliconLoaded) {
            API.registerRecipeHandler((ICraftingHandler)new AssemblyRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new AssemblyRecipeHandler());
            RecipeHandlerUtils.addToRecipeList("Buildcraft", assemblyTable, "Assembly Table", 0, "buildcraft.assembly", new Object[0]);
            Class cls = Utils.findClass("buildcraft.silicon.gui.GuiAssemblyTable");
            if (cls != null) {
                API.registerGuiOverlay((Class)cls, (String)"buildcraft.assemblyTable", (int)-17, (int)30);
                API.registerGuiOverlayHandler((Class)cls, (IOverlayHandler)new DefaultOverlayHandler(-17, 30), (String)"buildcraft.assemblyTable");
            }
        } else {
            NEIPlugins.log(Level.INFO, "Mod Buildcraft|Silicon not found", new Object[0]);
        }
        BuildcraftFuelHelper.registerFuelHelpers();
    }

    private void configureItemPanel() {
        String[] fields;
        Class cls = Utils.findClass("buildcraft.BuildCraftCore");
        if (cls == null) {
            return;
        }
        MultiItemRange blocks = new MultiItemRange();
        MultiItemRange blocksFactory = new MultiItemRange();
        MultiItemRange blocksBuilders = new MultiItemRange();
        MultiItemRange parts = new MultiItemRange();
        MultiItemRange transportPipes = new MultiItemRange();
        MultiItemRange liquidPipes = new MultiItemRange();
        MultiItemRange powerPipes = new MultiItemRange();
        MultiItemRange pipes = new MultiItemRange();
        MultiItemRange liquids = new MultiItemRange();
        MultiItemRange silicon = new MultiItemRange();
        for (String field : fields = new String[]{"woodenGearItem", "stoneGearItem", "ironGearItem", "goldGearItem", "diamondGearItem", "wrenchItem"}) {
            ItemApiHelper.addByFieldNameToRange(parts, cls, field);
        }
        ItemApiHelper.addByFieldNameToRange(blocks, cls, "springBlock");
        ItemApiHelper.setOverrideNameByFieldName("Water Spring", cls, "springBlock");
        if (buildersLoaded && (cls = Utils.findClass("buildcraft.BuildCraftBuilders")) != null) {
            for (String field : fields = new String[]{"markerBlock", "pathMarkerBlock", "fillerBlock", "builderBlock", "architectBlock", "libraryBlock"}) {
                ItemApiHelper.addByFieldNameToRange(blocksBuilders, cls, field);
            }
            ItemApiHelper.addByFieldNameToRange(parts, cls, "templateItem");
            ItemApiHelper.addByFieldNameToRange(parts, cls, "blueprintItem");
        }
        if (energyLoaded && (cls = Utils.findClass("buildcraft.BuildCraftEnergy")) != null) {
            for (String field : fields = new String[]{"oilMoving", "oilStill", "bucketOil", "bucketFuel", "fuel"}) {
                ItemApiHelper.addByFieldNameToRange(liquids, cls, field);
            }
            ItemApiHelper.addByFieldNameToRange(blocks, cls, "engineBlock");
        }
        if (factoryLoaded && (cls = Utils.findClass("buildcraft.BuildCraftFactory")) != null) {
            for (String field : fields = new String[]{"quarryBlock", "miningWellBlock", "autoWorkbenchBlock", "pumpBlock", "tankBlock", "refineryBlock", "hopperBlock"}) {
                ItemApiHelper.addByFieldNameToRange(blocksFactory, cls, field);
            }
            ItemApiHelper.hideItemByFieldName(cls, "frameBlock");
            ItemApiHelper.hideItemByFieldName(cls, "plainPipeBlock");
            refineryBlock = ItemApiHelper.getItemStackByFieldName(cls, null, "refineryBlock");
        }
        if (siliconLoaded && (cls = Utils.findClass("buildcraft.BuildCraftSilicon")) != null) {
            ItemApiHelper.addByFieldNameToRange(blocks, cls, "laserBlock");
            ItemApiHelper.addByFieldNameToRange(blocks, cls, "assemblyTableBlock");
            ItemApiHelper.addByFieldNameToRange(silicon, cls, "redstoneChipset");
            assemblyTable = ItemApiHelper.getItemStackByFieldName(cls, null, "assemblyTableBlock");
        }
        if (transportLoaded && (cls = Utils.findClass("buildcraft.BuildCraftTransport")) != null) {
            for (String field : fields = new String[]{"redPipeWire", "bluePipeWire", "greenPipeWire", "yellowPipeWire"}) {
                ItemApiHelper.addByFieldNameToRange(silicon, cls, field);
            }
            for (String field : fields = new String[]{"pipeItemsWood", "pipeItemsStone", "pipeItemsCobblestone", "pipeItemsIron", "pipeItemsGold", "pipeItemsDiamond", "pipeItemsObsidian", "pipeItemsVoid", "pipeItemsSandstone", "pipeItemsEmerald"}) {
                ItemApiHelper.addByFieldNameToRange(transportPipes, cls, field);
            }
            for (String field : fields = new String[]{"pipeLiquidsWood", "pipeLiquidsCobblestone", "pipeLiquidsStone", "pipeLiquidsIron", "pipeLiquidsGold", "pipeLiquidsVoid", "pipeLiquidsSandstone", "pipeLiquidsEmerald"}) {
                ItemApiHelper.addByFieldNameToRange(liquidPipes, cls, field);
            }
            ItemApiHelper.hideItemByFieldName(cls, "genericPipeBlock");
            ItemApiHelper.addByFieldNameToRange(powerPipes, cls, "pipePowerWood");
            ItemApiHelper.addByFieldNameToRange(powerPipes, cls, "pipePowerStone");
            ItemApiHelper.addByFieldNameToRange(powerPipes, cls, "pipePowerGold");
            ItemApiHelper.addByFieldNameToRange(pipes, cls, "pipeStructureCobblestone");
            ItemApiHelper.addByFieldNameToRange(pipes, cls, "plugItem");
            ItemApiHelper.addByFieldNameToRange(parts, cls, "pipeWaterproof");
            ItemApiHelper.addSetRangeFromItem("Buildcraft.Silicon.Gates", cls, "pipeGate");
            ItemApiHelper.addSetRangeFromItem("Buildcraft.Silicon.Gates.Autarchic", cls, "pipeGateAutarchic");
            ItemApiHelper.addSetRangeFromItem("Buildcraft.Facades", cls, "facadeItem");
        }
        API.addSetRange((String)"Buildcraft.Blocks", (MultiItemRange)blocks);
        API.addSetRange((String)"Buildcraft.Blocks.Builders", (MultiItemRange)blocksBuilders);
        API.addSetRange((String)"Buildcraft.Blocks.Factory", (MultiItemRange)blocksFactory);
        API.addSetRange((String)"Buildcraft.Items", (MultiItemRange)parts);
        API.addSetRange((String)"Buildcraft.Liquids", (MultiItemRange)liquids);
        API.addSetRange((String)"Buildcraft.Pipes", (MultiItemRange)pipes);
        API.addSetRange((String)"Buildcraft.Pipes.Transport", (MultiItemRange)transportPipes);
        API.addSetRange((String)"Buildcraft.Pipes.Liquid", (MultiItemRange)liquidPipes);
        API.addSetRange((String)"Buildcraft.Pipes.Power", (MultiItemRange)powerPipes);
        API.addSetRange((String)"Buildcraft.Silicon", (MultiItemRange)silicon);
    }

    static {
        assemblyTable = null;
        refineryBlock = null;
    }
}

