/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.BinnieCore;
import binnie.core.block.ItemMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.core.liquid.ILiquidType;
import binnie.core.plugin.IBinnieModule;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.PluginExtraTrees;
import binnie.extratrees.block.BlockETDoor;
import binnie.extratrees.block.BlockETLog;
import binnie.extratrees.block.BlockETPlanks;
import binnie.extratrees.block.BlockETSlab;
import binnie.extratrees.block.BlockETStairs;
import binnie.extratrees.block.BlockFence;
import binnie.extratrees.block.BlockGate;
import binnie.extratrees.block.DoorBlockRenderer;
import binnie.extratrees.block.DoorType;
import binnie.extratrees.block.FenceRenderer;
import binnie.extratrees.block.GateItemRenderer;
import binnie.extratrees.block.ILogType;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.ItemETDoor;
import binnie.extratrees.block.ItemETDoubleSlab;
import binnie.extratrees.block.ItemETSlab;
import binnie.extratrees.block.ItemETStairs;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.block.StairItemRenderer;
import binnie.extratrees.block.StairsRenderer;
import binnie.extratrees.config.ConfigurationMain;
import binnie.extratrees.item.ExtraTreeLiquid;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleBlocks
implements IBinnieModule {
    @Override
    public void preInit() {
        PlankType.setup();
        ExtraTrees.blockPlanks = new BlockETPlanks(ConfigurationMain.planksID);
        ExtraTrees.blockFence = new BlockFence(ConfigurationMain.fenceID);
        ExtraTrees.blockLog = new BlockETLog(ConfigurationMain.logID);
        ExtraTrees.blockGate = new BlockGate(ConfigurationMain.gateID);
        ExtraTrees.blockDoor = new BlockETDoor(ConfigurationMain.doorID);
        ExtraTrees.blockSlab = new BlockETSlab(ConfigurationMain.slabID, false);
        ExtraTrees.blockDoubleSlab = new BlockETSlab(ConfigurationMain.doubleSlabID, true);
        ExtraTrees.blockStairs = new BlockETStairs(ConfigurationMain.stairsID, ExtraTrees.blockPlanks);
        GameRegistry.registerBlock((Block)ExtraTrees.blockPlanks, ItemMetadata.class, (String)"extratrees.block.planks");
        GameRegistry.registerBlock((Block)ExtraTrees.blockFence, ItemMetadata.class, (String)"extratrees.block.fence");
        GameRegistry.registerBlock((Block)ExtraTrees.blockLog, ItemMetadata.class, (String)"extratrees.block.log");
        GameRegistry.registerBlock((Block)ExtraTrees.blockGate, ItemMetadata.class, (String)"extratrees.block.gate");
        GameRegistry.registerBlock((Block)ExtraTrees.blockSlab, ItemETSlab.class, (String)"extratrees.block.slab");
        GameRegistry.registerBlock((Block)ExtraTrees.blockDoubleSlab, ItemETDoubleSlab.class, (String)"extratrees.block.doubleSlab");
        GameRegistry.registerBlock((Block)ExtraTrees.blockDoor, ItemETDoor.class, (String)"extratrees.block.door");
        GameRegistry.registerBlock((Block)ExtraTrees.blockStairs, ItemETStairs.class, (String)"extratrees.block.stairs");
        for (int i = 0; i < PlankType.ExtraTreePlanks.values().length; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ExtraTrees.blockPlanks.field_71990_ca + "@" + i));
        }
        BinnieCore.proxy.registerCustomItemRenderer(Item.field_77698_e[ExtraTrees.blockStairs.field_71990_ca].field_77779_bT, new StairItemRenderer());
        BinnieCore.proxy.registerCustomItemRenderer(Item.field_77698_e[ExtraTrees.blockGate.field_71990_ca].field_77779_bT, new GateItemRenderer());
        Block.field_71982_s[ConfigurationMain.stairsID] = true;
        for (ILogType.ExtraTreeLog extraTreeLog : ILogType.ExtraTreeLog.values()) {
            OreDictionary.registerOre((String)"logWood", (ItemStack)extraTreeLog.getItemStack());
        }
        FurnaceRecipes.func_77602_a().func_77600_a(ExtraTrees.blockLog.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        for (Enum enum_ : PlankType.ExtraTreePlanks.values()) {
            OreDictionary.registerOre((String)"plankWood", (ItemStack)enum_.getPlank());
        }
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-fence-block", (String)(ExtraTrees.blockFence.field_71990_ca + ""));
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-fence-block", (String)(ExtraTrees.blockGate.field_71990_ca + ""));
    }

    @Override
    public void doInit() {
        PluginExtraTrees.fenceID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new FenceRenderer());
        PluginExtraTrees.stairsID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new StairsRenderer());
        PluginExtraTrees.doorRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new DoorBlockRenderer());
    }

    @Override
    public void postInit() {
        for (PlankType.ExtraTreePlanks plank : PlankType.ExtraTreePlanks.values()) {
            ItemStack planks = plank.getPlank();
            ItemStack slabs = TileEntityMetadata.getItemStack(ExtraTrees.blockSlab.field_71990_ca, plank.ordinal());
            ItemStack stairs = TileEntityMetadata.getItemStack(ExtraTrees.blockStairs.field_71990_ca, plank.ordinal());
            stairs.field_77994_a = 4;
            GameRegistry.addRecipe((ItemStack)stairs.func_77946_l(), (Object[])new Object[]{"#  ", "## ", "###", Character.valueOf('#'), planks.func_77946_l()});
            slabs.field_77994_a = 6;
            GameRegistry.addRecipe((ItemStack)slabs.func_77946_l(), (Object[])new Object[]{"   ", "   ", "###", Character.valueOf('#'), planks.func_77946_l()});
        }
        for (IPlankType plank : PlankType.getAllPlankTypes()) {
            ItemStack planks = plank.getPlank();
            ItemStack fence = PlankType.getFence(plank);
            ItemStack gate = PlankType.getGate(plank);
            ItemStack doorStandard = PlankType.getDoor(plank, DoorType.Standard);
            ItemStack doorSolid = PlankType.getDoor(plank, DoorType.Solid);
            ItemStack doorSplit = PlankType.getDoor(plank, DoorType.Double);
            ItemStack doorFull = PlankType.getDoor(plank, DoorType.Full);
            if (planks == null || fence == null || gate == null) continue;
            gate.field_77994_a = 2;
            GameRegistry.addRecipe((ItemStack)gate.func_77946_l(), (Object[])new Object[]{"#p#", Character.valueOf('#'), fence.func_77946_l(), Character.valueOf('p'), planks.func_77946_l()});
            fence.field_77994_a = 4;
            GameRegistry.addRecipe((ItemStack)fence.func_77946_l(), (Object[])new Object[]{"###", "# #", Character.valueOf('#'), planks.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)doorSolid.func_77946_l(), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), planks.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)doorStandard.func_77946_l(), (Object[])new Object[]{"# #", "###", "###", Character.valueOf('#'), planks.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)doorSplit.func_77946_l(), (Object[])new Object[]{"# #", "###", "# #", Character.valueOf('#'), planks.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)doorFull.func_77946_l(), (Object[])new Object[]{"# #", "# #", "# #", Character.valueOf('#'), planks.func_77946_l()});
        }
        MinecraftForge.setBlockHarvestLevel((Block)ExtraTrees.blockCarpentry, (String)"axe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ExtraTrees.blockFence, (String)"axe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ExtraTrees.blockPlanks, (String)"axe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ExtraTrees.blockLog, (String)"axe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ExtraTrees.blockStairs, (String)"axe", (int)0);
        this.addSqueezer(ILogType.VanillaLog.Oak, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.VanillaLog.Spruce, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.VanillaLog.Birch, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.VanillaLog.Jungle, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.LARCH, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.ForestryLog.TEAK, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.ACACIA, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.LIME, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.CHESTNUT, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.WENGE, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.BAOBAB, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.SEQUOIA, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.KAPOK, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.EBONY, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.MAHOGANY, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.BALSA, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.WILLOW, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.WALNUT, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.GREENHEART, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.CHERRY, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.MAHOE, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.POPLAR, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.ForestryLog.PALM, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.PAPAYA, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.PINE, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.ForestryLog.PLUM, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.MAPLE, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ForestryLog.CITRUS, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Apple, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Butternut, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Cherry, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Rowan, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Hemlock, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Ash, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Alder, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Beech, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Hawthorn, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Banana, ExtraTreeLiquid.Sap, 25);
        this.addSqueezer(ILogType.ExtraTreeLog.Yew, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Cypress, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Fir, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Hazel, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Hickory, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Elm, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Elder, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Holly, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Hornbeam, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Cedar, ExtraTreeLiquid.Resin, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Olive, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Sweetgum, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Locust, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Pear, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Maclura, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Brazilwood, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Logwood, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Rosewood, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Purpleheart, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Iroko, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Gingko, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Eucalyptus, ExtraTreeLiquid.Sap, 50, 1.0f);
        this.addSqueezer(ILogType.ExtraTreeLog.Eucalyptus2, ExtraTreeLiquid.Sap, 50, 1.0f);
        this.addSqueezer(ILogType.ExtraTreeLog.Box, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Syzgium, ExtraTreeLiquid.Sap, 50);
        this.addSqueezer(ILogType.ExtraTreeLog.Eucalyptus3, ExtraTreeLiquid.Sap, 50, 1.0f);
        this.addSqueezer(ILogType.ExtraTreeLog.Cinnamon, ExtraTreeLiquid.Sap, 50, 1.0f);
    }

    public void addSqueezer(ILogType log, ILiquidType liquid, int amount, float pulpChance) {
        LiquidStack liquidStack = liquid.get(amount);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{log.getItemStack()}, liquidStack, ItemInterface.getItem((String)"woodPulp"), (int)(100.0f * pulpChance));
    }

    public void addSqueezer(ILogType log, ILiquidType liquid, int amount) {
        this.addSqueezer(log, liquid, amount, 0.5f);
    }
}

