/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.PluginExtraTrees;
import binnie.extratrees.block.DoorType;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.PlankType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockETDoor
extends BlockDoor
implements IBlockMetadata {
    private Icon getFlippedIcon(boolean upper, boolean flip, int tileMeta) {
        DoorType type = BlockETDoor.getDoorType(tileMeta);
        return upper ? (flip ? type.iconDoorUpperFlip : type.iconDoorUpper) : (flip ? type.iconDoorLowerFlip : type.iconDoorLower);
    }

    public static DoorType getDoorType(int tileMeta) {
        int type = (tileMeta & 0xF00) >> 8;
        if (type >= 0 && type < DoorType.values().length) {
            return DoorType.values()[type];
        }
        return DoorType.Standard;
    }

    protected BlockETDoor(int par1) {
        super(par1, Material.field_76245_d);
        this.func_71848_c(3.0f).func_71884_a(field_71967_e);
        this.func_71849_a(Tabs.tabArboriculture);
    }

    public Icon func_71858_a(int side, int meta) {
        return DoorType.Standard.iconDoorLower;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (par5 != 1 && par5 != 0) {
            boolean flag2;
            int i1 = this.func_72234_b_(par1IBlockAccess, par2, par3, par4);
            int j1 = i1 & 3;
            boolean flag = (i1 & 4) != 0;
            boolean flag1 = false;
            boolean bl = flag2 = (i1 & 8) != 0;
            if (flag) {
                if (j1 == 0 && par5 == 2) {
                    flag1 = !flag1;
                } else if (j1 == 1 && par5 == 5) {
                    flag1 = !flag1;
                } else if (j1 == 2 && par5 == 3) {
                    flag1 = !flag1;
                } else if (j1 == 3 && par5 == 4) {
                    flag1 = !flag1;
                }
            } else {
                if (j1 == 0 && par5 == 5) {
                    flag1 = !flag1;
                } else if (j1 == 1 && par5 == 3) {
                    flag1 = !flag1;
                } else if (j1 == 2 && par5 == 4) {
                    flag1 = !flag1;
                } else if (j1 == 3 && par5 == 2) {
                    boolean bl2 = flag1 = !flag1;
                }
                if ((i1 & 0x10) != 0) {
                    flag1 = !flag1;
                }
            }
            int tileMeta = 0;
            tileMeta = flag2 ? TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3 - 1, par4) : TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3, par4);
            return this.getFlippedIcon(flag2, flag1, tileMeta);
        }
        return DoorType.Standard.iconDoorLower;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        for (DoorType type : DoorType.values()) {
            type.iconDoorLower = ExtraTrees.proxy.getIcon(register, "door." + type.iconName + ".lower");
            type.iconDoorUpper = ExtraTrees.proxy.getIcon(register, "door." + type.iconName + ".upper");
            type.iconDoorLowerFlip = new IconFlipped(type.iconDoorLower, true, false);
            type.iconDoorUpperFlip = new IconFlipped(type.iconDoorUpper, true, false);
        }
    }

    public int func_71857_b() {
        return PluginExtraTrees.doorRenderId;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        boolean flag2;
        int par5 = 2;
        int i1 = this.func_72234_b_(par1IBlockAccess, par2, par3, par4);
        int j1 = i1 & 3;
        boolean flag = (i1 & 4) != 0;
        boolean flag1 = false;
        boolean bl = flag2 = (i1 & 8) != 0;
        if (flag) {
            if (j1 == 0 && par5 == 2) {
                flag1 = !flag1;
            } else if (j1 == 1 && par5 == 5) {
                flag1 = !flag1;
            } else if (j1 == 2 && par5 == 3) {
                flag1 = !flag1;
            } else if (j1 == 3 && par5 == 4) {
                flag1 = !flag1;
            }
        } else {
            if (j1 == 0 && par5 == 5) {
                flag1 = !flag1;
            } else if (j1 == 1 && par5 == 3) {
                flag1 = !flag1;
            } else if (j1 == 2 && par5 == 4) {
                flag1 = !flag1;
            } else if (j1 == 3 && par5 == 2) {
                boolean bl2 = flag1 = !flag1;
            }
            if ((i1 & 0x10) != 0) {
                boolean bl3 = flag1 = !flag1;
            }
        }
        if (flag2) {
            int meta = TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3 - 1, par4);
            return PlankType.getPlank(meta & 0xFF).getColour();
        }
        int meta = TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3, par4);
        return PlankType.getPlank(meta & 0xFF).getColour();
    }

    public int func_72234_b_(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int j1;
        int i1;
        boolean flag;
        int l = par1IBlockAccess.func_72805_g(par2, par3, par4);
        boolean bl = flag = (l & 8) != 0;
        if (flag) {
            i1 = par1IBlockAccess.func_72805_g(par2, par3 - 1, par4);
            j1 = l;
        } else {
            i1 = l;
            j1 = par1IBlockAccess.func_72805_g(par2, par3 + 1, par4);
        }
        boolean flag1 = (j1 & 1) != 0;
        return i1 & 7 | (flag ? 8 : 0) | (flag1 ? 16 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71846_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        if (par6EntityPlayer.field_71075_bZ.field_75098_d && (par5 & 8) != 0 && par1World.func_72798_a(par2, par3 - 1, par4) == this.field_71990_ca) {
            par1World.func_94571_i(par2, par3 - 1, par4);
        }
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_72274_a(World var1) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_71883_b(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_71883_b(par1World, par2, par3, par4, par5, par6);
        TileEntity tileentity = par1World.func_72796_p(par2, par3, par4);
        return tileentity != null ? tileentity.func_70315_b(par5, par6) : false;
    }

    @Override
    public int getPlacedMeta(ItemStack stack, World world, int x, int y, int z, ForgeDirection clickedBlock) {
        return TileEntityMetadata.getItemDamage(stack);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack par1ItemStack) {
        int meta = TileEntityMetadata.getItemDamage(par1ItemStack);
        DoorType type = BlockETDoor.getDoorType(meta);
        return type.name + PlankType.getPlank(meta & 0xFF).getName() + " Wood Door";
    }

    @Override
    public void getBlockTooltip(ItemStack par1ItemStack, List par3List) {
    }

    @Override
    public int getBlockID() {
        return this.field_71990_ca;
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack drop) {
        this.func_71929_a(world, x, y, z, drop);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (PlankType.ExtraTreePlanks extraTreePlanks : PlankType.ExtraTreePlanks.values()) {
            itemList.add(PlankType.getDoor(extraTreePlanks, DoorType.Standard));
        }
        for (Enum enum_ : PlankType.ForestryPlanks.values()) {
            itemList.add(PlankType.getDoor((IPlankType)((Object)enum_), DoorType.Standard));
        }
        for (Enum enum_ : PlankType.ExtraBiomesPlank.values()) {
            if (enum_.getPlank() == null) continue;
            itemList.add(PlankType.getDoor((IPlankType)((Object)enum_), DoorType.Standard));
        }
        for (Enum enum_ : PlankType.VanillaPlanks.values()) {
            itemList.add(PlankType.getDoor((IPlankType)((Object)enum_), DoorType.Standard));
        }
    }

    public boolean isWood(World world, int x, int y, int z) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 5;
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
        par1World.func_72932_q(par2, par3, par4);
    }
}

