/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.genetics.BinnieGenetics;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.power.ErrorState;
import binnie.extrabees.config.ConfigurationMachines;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.engineering.ModuleEngineering;
import binnie.extrabees.machines.logic.SlotValidatorBee;
import binnie.extrabees.machines.logic.SlotValidatorSerum;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class TileEntityIsolator
extends TileEntityMachine
implements IInventory,
IPowerReceptor {
    public static final int SlotBee = 2;
    public static final int SlotVials = 3;
    public static final int[] SlotVialsDone = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int[] SlotBeeQueue = new int[]{13, 14, 15, 16, 17, 18};

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Isolator;
    }

    public TileEntityIsolator() {
        super("Isolator", 20000, 400, 60000);
        this.addSlot(2, InventorySlot.NameProcess);
        this.addSlot(3, "Vial Slot");
        this.addSlotArray(SlotVialsDone, InventorySlot.NameOutput);
        this.addSlotArray(SlotBeeQueue, InventorySlot.NameInput);
        this.getSlot(2).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
        this.getSlot(2).setReadOnly();
        this.getSlot(2).forbidInteraction();
        this.getSlot(3).setValidator(new SlotValidatorSerum(SlotValidatorSerum.Mode.Empty));
        this.getSlot(3).forbidExtraction();
        for (int slot : SlotVialsDone) {
            this.getSlot(slot).setValidator(new SlotValidatorSerum(SlotValidatorSerum.Mode.Serum));
            this.getSlot(slot).setReadOnly();
        }
        for (int slot : SlotBeeQueue) {
            this.getSlot(slot).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
            this.getSlot(slot).forbidExtraction();
        }
        this.transfer.addRestock(SlotBeeQueue, 2);
    }

    public Integer[] getFreeVialSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i : SlotVialsDone) {
            InventorySlot slot = this.getSlot(i);
            if (slot.getItemStack() != null) continue;
            slots.add(i);
        }
        return slots.toArray(new Integer[0]);
    }

    @Override
    public void onFinishTask() {
        Integer[] freeSlots = this.getFreeVialSlots();
        EnumBeeChromosome[] chromosomes = new EnumBeeChromosome[]{EnumBeeChromosome.SPECIES, EnumBeeChromosome.SPECIES, EnumBeeChromosome.SPECIES, EnumBeeChromosome.EFFECT, EnumBeeChromosome.EFFECT, EnumBeeChromosome.FLOWER_PROVIDER, EnumBeeChromosome.FLOWER_PROVIDER, EnumBeeChromosome.NOCTURNAL, EnumBeeChromosome.TOLERANT_FLYER, EnumBeeChromosome.CAVE_DWELLING, EnumBeeChromosome.SPEED, EnumBeeChromosome.SPEED, EnumBeeChromosome.LIFESPAN, EnumBeeChromosome.LIFESPAN, EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumBeeChromosome.FERTILITY, EnumBeeChromosome.FERTILITY, EnumBeeChromosome.FLOWERING, EnumBeeChromosome.FLOWERING, EnumBeeChromosome.TERRITORY};
        IBeeGenome genome = BinnieGenetics.getBeeRoot().getMember(this.getSlot(2).getItemStack()).getGenome();
        ItemStack itemStack = null;
        while (itemStack == null) {
            EnumBeeChromosome chromosome = chromosomes[this.field_70331_k.field_73012_v.nextInt(chromosomes.length)];
            IAllele allele = this.field_70331_k.field_73012_v.nextBoolean() ? genome.getActiveAllele(chromosome.ordinal()) : genome.getInactiveAllele(chromosome.ordinal());
            itemStack = ModuleEngineering.tryCreateSerum(allele, chromosome, 5);
        }
        itemStack.func_77964_b(itemStack.func_77973_b().func_77612_l());
        this.func_70299_a(freeSlots[0], itemStack);
        this.func_70298_a(3, 1);
        if (this.field_70331_k.field_73012_v.nextInt(100) < ConfigurationMachines.isolatorConsumptionChance) {
            this.func_70298_a(2, 1);
        }
    }

    @Override
    public ErrorState canWork() {
        if (this.getSlot(2).getItemStack() == null) {
            return new ErrorState.NoItem("No Bee to isolate genes from", 2);
        }
        if (this.getSlot(3).getItemStack() == null) {
            return new ErrorState.NoItem("No Empty Vials to fill", 3);
        }
        if (this.getFreeVialSlots().length == 0) {
            return new ErrorState.NoSpace("No Space for New Vials", SlotVialsDone);
        }
        return super.canWork();
    }

    @Override
    public String getInformation() {
        return "The Isolator fills empty serum vials with alleles extracted from bee species.";
    }
}

