/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.machines.inventory.IValidatedTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ErrorState;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.machines.logic.LogicMachine;
import binnie.extrabees.machines.logic.SlotValidatorBee;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileEntityGenepool
extends TileEntityMachine
implements IPowerReceptor,
ITankContainer,
IValidatedTankContainer {
    public static final int[] SlotReserve = new int[]{4, 5, 6, 7, 8, 9};
    public static final int SlotBee = 2;

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Genepool;
    }

    public TileEntityGenepool() {
        super("Genepool", 1000, 200, 2000);
        this.addSlot(2, InventorySlot.NameProcess);
        this.addSlotArray(SlotReserve, InventorySlot.NameInput);
        this.getSlot(2).setReadOnly();
        this.getSlot(2).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
        for (int slot : SlotReserve) {
            this.getSlot(slot).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
        }
        this.addTank(0, "DNA Tank", 2000);
        this.getTankSlot(0).setValidator(new TankValidator.Basic("liquidDNA"));
        this.getTankSlot(0).setReadOnly();
        this.transfer.addRestock(SlotReserve, 2, 1);
    }

    @Override
    public void onFinishTask() {
        if ((double)LogicMachine.getDNAAmount(this.func_70301_a(2)) > 0.0) {
            this.fill(0, new LiquidStack(ExtraBees.liquidDNA, LogicMachine.getDNAAmount(this.func_70301_a(2))), true);
        }
        this.func_70298_a(2, 1);
    }

    @Override
    public ErrorState canWork() {
        if (this.func_70301_a(2) == null) {
            return new ErrorState.NoItem("No bee", new int[]{2, 4, 5, 6, 7, 8, 9});
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        int space;
        int newAmount = LogicMachine.getDNAAmount(this.func_70301_a(2));
        int n = space = this.getTank(0).getLiquid() == null ? this.getTank(0).getCapacity() : this.getTank(0).getCapacity() - this.getTank((int)0).getLiquid().amount;
        if (space < newAmount) {
            return new ErrorState.TankSpace("Not enough space for Liquid DNA", 0);
        }
        return super.canProgress();
    }

    @Override
    public String getInformation() {
        return "The Genepool extracts Liquid DNA from bees. Princesses, Queens and Analyzed bees are worth more DNA.";
    }
}

