/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.power.ErrorState;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.machines.logic.LogicAcclimatiser;
import binnie.extrabees.machines.logic.SlotValidatorAcclimatiser;
import binnie.extrabees.machines.logic.SlotValidatorBee;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityAcclimatiser
extends TileEntityMachine
implements IPowerReceptor {
    public static final int SlotItem = 2;
    public static final int SlotBee = 3;

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Acclimatiser;
    }

    @Override
    public ErrorState canWork() {
        if (this.func_70301_a(3) == null) {
            return new ErrorState.NoItem("No Bee to Acclimatise", 3);
        }
        if (!LogicAcclimatiser.isAcclimatiserItem(this.func_70301_a(2))) {
            return new ErrorState.InvalidItem("Cannot Acclimatise using this item", 2);
        }
        if (!LogicAcclimatiser.canAcclimatise(this.func_70301_a(3), this.func_70301_a(2))) {
            return new ErrorState.InvalidItem("Cannot Acclimatise further", 3);
        }
        return super.canWork();
    }

    @Override
    public void onFinishTask() {
        ItemStack item;
        ItemStack bee = this.func_70301_a(3);
        if (LogicAcclimatiser.canAcclimatise(bee, item = this.func_70301_a(2))) {
            LogicAcclimatiser.acclimatise(this.field_70331_k, bee, item);
            this.func_70298_a(2, 1);
        }
    }

    public TileEntityAcclimatiser() {
        super("Acclimatiser", 500, 200, 1000);
        this.addSlot(3, "Bee Slot");
        this.getSlot(3).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
        this.getSlot(3).setOutputSides(MachineSide.Sides);
        this.addSlot(2, "Acclimatiser Slot");
        this.getSlot(2).setValidator(new SlotValidatorAcclimatiser());
        this.getSlot(2).setOutputSides(MachineSide.TopAndBottom);
    }

    protected int[] getSlotsToExtract(ForgeDirection from) {
        int[] nArray;
        if (from == ForgeDirection.UP || from == ForgeDirection.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 3;
        }
        return nArray;
    }

    @Override
    public String getInformation() {
        return "The Acclimatiser is used to alter the humidity or temperature tolerance of a bee using certain items. ";
    }
}

