/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.BinnieCore;
import binnie.core.genetics.BinnieGenetics;
import binnie.core.liquid.LiquidManager;
import binnie.core.plugin.IBinnieModule;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.config.ConfigurationMain;
import binnie.extrabees.genetics.EnumExtraBeeBranch;
import binnie.extrabees.genetics.EnumExtraBeeFlowers;
import binnie.extrabees.genetics.EnumExtraBeeSpecies;
import binnie.extrabees.genetics.ExtraBeeMutation;
import binnie.extrabees.genetics.effect.BlockEctoplasm;
import binnie.extrabees.genetics.effect.EnumExtraBeeEffect;
import binnie.extrabees.genetics.items.ItemDictionary;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.recipes.RecipeManagers;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ModuleGenetics
implements IBinnieModule {
    @Override
    public void preInit() {
    }

    @Override
    public void doInit() {
        ExtraBees.dictionary = new ItemDictionary(ConfigurationMain.dictionaryID);
        ExtraBees.ectoplasm = new BlockEctoplasm(ConfigurationMain.ectoplasmID);
        GameRegistry.registerBlock((Block)ExtraBees.ectoplasm, (String)"extrabees.block.ectoplasm");
        BinnieCore.proxy.addName(ExtraBees.ectoplasm, "Ectoplasm");
    }

    @Override
    public void postInit() {
        EnumExtraBeeEffect.doInit();
        EnumExtraBeeFlowers.doInit();
        EnumExtraBeeSpecies.doInit();
        ExtraBeeMutation.doInit();
        EnumExtraBeeBranch.doInit();
        int ebSpeciesCount = 0;
        int ebTotalSpeciesCount = 0;
        for (EnumExtraBeeSpecies species : EnumExtraBeeSpecies.values()) {
            ++ebTotalSpeciesCount;
            if (AlleleManager.alleleRegistry.isBlacklisted(species.getUID())) continue;
            ++ebSpeciesCount;
        }
        ExtraBees.instance.log().info("Added " + ebSpeciesCount + " species, out of a total of " + ebTotalSpeciesCount);
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraBees.templateBlank), (Object[])new Object[]{" G ", "GHG", " G ", Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('H'), ItemInterface.getItem((String)"honeydew")});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraBees.serumEmpty, 2), (Object[])new Object[]{"GgG", "GHG", "GgG", Character.valueOf('g'), Item.field_77717_p, Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('H'), ItemInterface.getItem((String)"royalJelly")});
        RecipeManagers.carpenterManager.addRecipe(100, LiquidManager.getLiquidStack("Water", 2000), null, new ItemStack(ExtraBees.dictionary), new Object[]{"X#X", "YEY", "RDR", Character.valueOf('#'), Block.field_72003_bq, Character.valueOf('X'), Item.field_77717_p, Character.valueOf('Y'), "ingotTin", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('E'), Item.field_77817_bH});
        GameRegistry.addSmelting((int)ExtraBees.serum.field_77779_bT, (ItemStack)new ItemStack(ExtraBees.serumEmpty), (float)0.0f);
    }

    public static IGenome getGenome(IAlleleBeeSpecies allele0) {
        return BinnieGenetics.getBeeRoot().templateAsGenome(BinnieGenetics.getBeeRoot().getTemplate(allele0.getUID()));
    }

    public static ItemStack getBeeIcon(IAlleleBeeSpecies species) {
        if (species == null) {
            return null;
        }
        IAllele[] template = BinnieGenetics.getBeeRoot().getTemplate(species.getUID());
        if (template == null) {
            return null;
        }
        IBeeGenome genome = BinnieGenetics.getBeeRoot().templateAsGenome(template);
        IBee bee = BinnieGenetics.getBeeRoot().getBee(BinnieCore.proxy.getWorld(), genome);
        ItemStack item = BinnieGenetics.getBeeRoot().getMemberStack((IIndividual)bee, EnumBeeType.PRINCESS.ordinal());
        return item;
    }
}

