/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum EnumExtraBeeFlowers implements IFlowerProvider,
IAlleleFlowers
{
    WATER("Lily Pad"),
    SUGAR("Reeds"),
    ROCK("Rocks"),
    BOOK("Books"),
    DEAD("Dead Bush"),
    REDSTONE("Redstone"),
    WOOD("Wood"),
    LEAVES("Leaves"),
    Sapling("Sapling"),
    Fruit("Fruit");

    String name = "";
    boolean dominant = true;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumExtraBeeFlowers() {
        void name;
        this.name = name;
    }

    public String getUID() {
        return "extrabees.flower." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public IFlowerProvider getProvider() {
        return this;
    }

    public String getDescription() {
        return this.name;
    }

    public void register() {
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
    }

    public static void doInit() {
        AlleleManager.alleleRegistry.blacklistAllele("extrabees.flower.none");
        for (EnumExtraBeeFlowers effect : EnumExtraBeeFlowers.values()) {
            effect.register();
        }
    }

    public ItemStack[] getItemStacks() {
        switch (this) {
            case WATER: {
                return new ItemStack[]{new ItemStack(Block.field_71991_bz)};
            }
            case SUGAR: {
                return new ItemStack[]{new ItemStack(Block.field_72040_aX)};
            }
            case ROCK: {
                return new ItemStack[]{new ItemStack(Block.field_71978_w)};
            }
            case BOOK: {
                return new ItemStack[]{new ItemStack(Block.field_72093_an)};
            }
            case REDSTONE: {
                return new ItemStack[]{new ItemStack(Block.field_72035_aQ)};
            }
        }
        return null;
    }

    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        return false;
    }

    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block == null) {
            return false;
        }
        switch (this) {
            case WATER: {
                return block.field_71990_ca == Block.field_71991_bz.field_71990_ca;
            }
            case ROCK: {
                return block.field_72018_cp == Material.field_76246_e;
            }
            case SUGAR: {
                return block.field_71990_ca == Block.field_72040_aX.field_71990_ca;
            }
            case BOOK: {
                return block.field_71990_ca == Block.field_72093_an.field_71990_ca;
            }
            case REDSTONE: {
                return block.field_71990_ca == Block.field_72035_aQ.field_71990_ca;
            }
            case DEAD: {
                return block.field_71990_ca == Block.field_71961_Y.field_71990_ca;
            }
            case WOOD: {
                return block.isWood(world, x, y, z);
            }
            case Fruit: {
                return world.func_72796_p(x, y, z) instanceof IFruitBearer;
            }
            case LEAVES: {
                return block.isLeaves(world, x, y, z);
            }
            case Sapling: {
                return block.getClass().getName().toLowerCase().contains("sapling");
            }
        }
        return false;
    }

    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        switch (this) {
            case WATER: {
                if (world.func_72799_c(x, y, z) && world.func_72798_a(x, y - 1, z) == Block.field_71943_B.field_71990_ca) {
                    return world.func_72832_d(x, y, z, Block.field_71991_bz.field_71990_ca, 0, 2);
                }
                return false;
            }
            case SUGAR: {
                if (world.func_72798_a(x, y - 1, z) == Block.field_72040_aX.field_71990_ca && world.func_72799_c(x, y, z)) {
                    return world.func_72832_d(x, y, z, Block.field_72040_aX.field_71990_ca, 0, 0);
                }
                return false;
            }
        }
        return false;
    }

    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    public String getName() {
        return this.getDescription();
    }
}

