/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine;

import binnie.core.circuits.BinnieCircuit;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.extrabees.apiary.ComponentBeeModifier;
import binnie.extrabees.apiary.ComponentExtraBeeGUI;
import binnie.extrabees.apiary.machine.AlvearyMachine;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.core.ExtraBeeTexture;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ItemInterface;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class AlvearyStimulator {
    public static int slotCircuit = 0;

    public static enum CircuitType implements IBeeModifier
    {
        LowVoltage("Low Voltage Stimulus", 3),
        HighVoltage("High Voltage Stimulus", 5),
        Plant("Biotic Stimulus", 10),
        Death("Overpowered Stimulus", 6),
        Life("Gentle Stimulus", 11),
        Nether("Molten Stimulus", 7),
        Mutation("Mutagenic Stimulus", 4);

        public String name;
        public int recipe;

        /*
         * WARNING - void declaration
         */
        private CircuitType() {
            void recipe;
            void name;
            this.name = name;
            this.recipe = recipe;
        }

        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return 1.0f;
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 1.0f;
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            if (this == LowVoltage) {
                return Math.max(1.2f, 4.0f / currentModifier);
            }
            if (this == HighVoltage) {
                return Math.max(1.6f, 10.0f / currentModifier);
            }
            return 1.0f;
        }

        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return 1.0f;
        }

        public boolean isSealed() {
            return false;
        }

        public boolean isSelfLighted() {
            return false;
        }

        public boolean isSunlightSimulated() {
            return false;
        }

        public boolean isHellish() {
            return false;
        }
    }

    public static class StimulatorCircuit
    extends BinnieCircuit
    implements IBeeModifier {
        CircuitType type;

        public StimulatorCircuit(CircuitType type, ICircuitLayout layout) {
            super(type.name, "Stimulator" + type.toString(), 4, layout, ItemInterface.getItem((String)"tubes").field_77993_c, type.recipe);
            this.type = type;
        }

        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return this.type.getTerritoryModifier(genome, currentModifier);
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.type.getMutationModifier(genome, mate, currentModifier);
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.type.getLifespanModifier(genome, mate, currentModifier);
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return this.type.getProductionModifier(genome, currentModifier);
        }

        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return this.type.getFloweringModifier(genome, currentModifier);
        }

        public boolean isSealed() {
            return this.type.isSealed();
        }

        public boolean isSelfLighted() {
            return this.type.isSelfLighted();
        }

        public boolean isSunlightSimulated() {
            return this.type.isSunlightSimulated();
        }

        public boolean isHellish() {
            return this.type.isHellish();
        }
    }

    public static class ComponentStimulatorModifier
    extends ComponentBeeModifier
    implements IBeeModifier,
    IBeeListener {
        IBeeModifier[] modifiers;

        public ComponentStimulatorModifier(Machine machine) {
            super(machine);
        }

        @Override
        public void onInventoryUpdate() {
            super.onInventoryUpdate();
            this.modifiers = this.getCircuits();
        }

        @Override
        public void wearOutEquipment(int amount) {
        }

        public ICircuitBoard getHiveFrame() {
            if (!this.getUtil().isSlotEmpty(slotCircuit)) {
                return ChipsetManager.circuitRegistry.getCircuitboard(this.getUtil().getStack(slotCircuit));
            }
            return null;
        }

        public IBeeModifier[] getCircuits() {
            ICircuitBoard board = this.getHiveFrame();
            if (board == null) {
                return new IBeeModifier[0];
            }
            ICircuit[] circuits = board.getCircuits();
            ArrayList<IBeeModifier> mod = new ArrayList<IBeeModifier>();
            for (ICircuit circuit : circuits) {
                if (!(circuit instanceof IBeeModifier)) continue;
                mod.add((IBeeModifier)circuit);
            }
            return mod.toArray(new IBeeModifier[0]);
        }

        @Override
        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            float mod = currentModifier;
            for (IBeeModifier beeMod : this.modifiers) {
                mod *= beeMod.getTerritoryModifier(genome, mod);
            }
            return mod;
        }

        @Override
        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            float mod = currentModifier;
            for (IBeeModifier beeMod : this.modifiers) {
                mod *= beeMod.getMutationModifier(genome, mate, mod);
            }
            return mod;
        }

        @Override
        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            float mod = currentModifier;
            for (IBeeModifier beeMod : this.modifiers) {
                mod *= beeMod.getLifespanModifier(genome, mate, mod);
            }
            return mod;
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            float mod = currentModifier;
            for (IBeeModifier beeMod : this.modifiers) {
                mod *= beeMod.getProductionModifier(genome, mod);
            }
            return mod;
        }

        @Override
        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            float mod = currentModifier;
            for (IBeeModifier beeMod : this.modifiers) {
                mod *= beeMod.getFloweringModifier(genome, mod);
            }
            return mod;
        }

        @Override
        public boolean isSealed() {
            for (IBeeModifier beeMod : this.modifiers) {
                if (!beeMod.isSealed()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSelfLighted() {
            for (IBeeModifier beeMod : this.modifiers) {
                if (!beeMod.isSelfLighted()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSunlightSimulated() {
            for (IBeeModifier beeMod : this.modifiers) {
                if (!beeMod.isSunlightSimulated()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isHellish() {
            for (IBeeModifier beeMod : this.modifiers) {
                if (!beeMod.isHellish()) continue;
                return true;
            }
            return false;
        }
    }

    public static class SlotValidatorCircuit
    extends SlotValidator {
        public SlotValidatorCircuit() {
            super(SlotValidator.IconCircuit);
        }

        public boolean isValid(ItemStack itemStack) {
            return itemStack != null && ChipsetManager.circuitRegistry.isChipset(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Forestry Circuits";
        }
    }

    public static class PackageAlvearyStimulator
    extends AlvearyMachine.AlvearyPackage {
        public PackageAlvearyStimulator() {
            super("stimulator", "Electrical Stimulator", ExtraBeeTexture.AlvearyStimulator.getTexture());
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentExtraBeeGUI(machine, ExtraBeeGUID.AlvearyStimulator);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(slotCircuit, "Circuit Slot");
            inventory.getSlot(slotCircuit).setValidator(new SlotValidatorCircuit());
            ComponentPowerReceptor power = new ComponentPowerReceptor(machine);
            new ComponentStimulatorModifier(machine);
        }
    }
}

